/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.util.stat;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Random;
import thunderheadeng.util.LinkedIdentityHashMap;
import thunderheadeng.util.stat.IUrn;
import thunderheadeng.util.stat.IUrnSampler;

public class Urn<T>
implements Serializable,
IUrn<T> {
    private static final long serialVersionUID = -2045357536456688958L;
    private List<T> d_values;

    public Urn(T ... TArray) {
        this((Collection<T>)Arrays.asList(TArray));
    }

    public Urn(Collection<? extends T> collection) {
        this.d_values = collection != null && collection.size() > 0 ? new ArrayList<T>(collection) : Collections.EMPTY_LIST;
    }

    @Override
    public void getUnique(Collection<? super T> collection) {
        collection.addAll(this.d_values);
    }

    @Override
    public Map<T, Double> getWeights() {
        LinkedIdentityHashMap<T, Double> linkedIdentityHashMap = new LinkedIdentityHashMap<T, Double>();
        for (T object : this.d_values) {
            Double d = (Double)linkedIdentityHashMap.get(object);
            if (d == null) {
                linkedIdentityHashMap.put(object, 1.0);
                continue;
            }
            linkedIdentityHashMap.put(object, d + 1.0);
        }
        for (Map.Entry entry : linkedIdentityHashMap.entrySet()) {
            entry.setValue((Double)entry.getValue() / (double)this.d_values.size());
        }
        return linkedIdentityHashMap;
    }

    public Map<T, Integer> getCounts() {
        LinkedIdentityHashMap<T, Integer> linkedIdentityHashMap = new LinkedIdentityHashMap<T, Integer>();
        for (T t : this.d_values) {
            Integer n = (Integer)linkedIdentityHashMap.get(t);
            if (n == null) {
                linkedIdentityHashMap.put(t, 1);
                continue;
            }
            linkedIdentityHashMap.put(t, n + 1);
        }
        return linkedIdentityHashMap;
    }

    public boolean equals(Object object) {
        return object == this || object instanceof Urn && ((Urn)object).d_values.equals(this.d_values);
    }

    public int hashCode() {
        return 0x95FA3 ^ this.d_values.hashCode();
    }

    public List<T> getValues() {
        return this.d_values;
    }

    @Override
    public T getValue(Random random) {
        if (this.d_values.size() == 0) {
            return null;
        }
        int n = random.nextInt(this.d_values.size());
        return this.d_values.get(n);
    }

    public Urn<T> shuffleRandomly(Random random) {
        Urn<T> urn = new Urn<T>(this.d_values);
        Collections.shuffle(urn.d_values, random);
        return urn;
    }

    @Override
    public IUrnSampler<T> getSampler(Random random) {
        int n = random.nextInt(this.d_values.size());
        return new Sampler(this, n);
    }

    public String toString() {
        return Arrays.toString(this.d_values.toArray());
    }

    private static class Sampler<T>
    implements IUrnSampler<T> {
        private final Urn<T> d_urn;
        private int d_samplingIndex;

        public Sampler(Urn<T> urn, int n) {
            this.d_urn = urn;
            this.d_samplingIndex = n;
        }

        @Override
        public T getCurrentSample() {
            return (T)((Urn)this.d_urn).d_values.get(this.d_samplingIndex);
        }

        @Override
        public T sampleNext() {
            T t = this.getCurrentSample();
            this.d_samplingIndex = (this.d_samplingIndex + 1) % ((Urn)this.d_urn).d_values.size();
            return t;
        }
    }
}

