/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.util.stat;

import java.io.Serializable;
import java.util.Random;
import org.jscience.physics.units.Unit;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.stat.ICurve;

public class UniformCurve
implements ICurve,
Serializable {
    static final long serialVersionUID = 1L;
    private final UnitDouble d_min;
    private final UnitDouble d_max;

    public UniformCurve(UnitDouble unitDouble, UnitDouble unitDouble2) {
        this.d_min = unitDouble;
        this.d_max = unitDouble2;
    }

    public int hashCode() {
        return 944781 + this.d_min.hashCode() + this.d_max.hashCode();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof UniformCurve)) {
            return false;
        }
        UniformCurve uniformCurve = (UniformCurve)object;
        return this.d_min.equals(uniformCurve.d_min) && this.d_max.equals(uniformCurve.d_max);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[");
        stringBuffer.append(this.d_min.toString());
        stringBuffer.append(", ");
        stringBuffer.append(this.d_max.toString());
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    @Override
    public UnitDouble getMin() {
        return this.d_min;
    }

    @Override
    public UnitDouble getMax() {
        return this.d_max;
    }

    @Override
    public UnitDouble getAvg() {
        Unit unit = this.d_min.getUnit();
        double d = (this.d_min.get(unit) + this.d_max.get(unit)) / 2.0;
        return new UnitDouble(d, unit);
    }

    @Override
    public UnitDouble getValue(Random random) {
        double d = random.nextDouble();
        return this.d_max.sub(this.d_min).scale(d).add(this.d_min);
    }
}

