/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.util.stat;

import java.io.Serializable;
import java.util.Random;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.stat.ICurve;
import thunderheadeng.util.stat.UniformCurve;

public class StdNormCurve
implements ICurve,
Serializable {
    static final long serialVersionUID = 1L;
    private final UnitDouble d_min;
    private final UnitDouble d_max;
    private final UnitDouble d_mean;
    private final UnitDouble d_stdDev;

    public StdNormCurve(UnitDouble unitDouble, UnitDouble unitDouble2, UnitDouble unitDouble3, UnitDouble unitDouble4) {
        assert (unitDouble4.getValueNoUnit() >= 0.0);
        this.d_min = unitDouble;
        this.d_max = unitDouble2;
        this.d_mean = unitDouble3;
        this.d_stdDev = unitDouble4;
    }

    public int hashCode() {
        return 420575 + this.d_min.hashCode() + this.d_max.hashCode() + this.d_mean.hashCode() + this.d_stdDev.hashCode();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof StdNormCurve)) {
            return false;
        }
        StdNormCurve stdNormCurve = (StdNormCurve)object;
        return this.d_min.equals(stdNormCurve.d_min) && this.d_max.equals(stdNormCurve.d_max) && this.d_mean.equals(stdNormCurve.d_mean) && this.d_stdDev.equals(stdNormCurve.d_stdDev);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("u=");
        stringBuffer.append(this.d_mean.toString());
        stringBuffer.append(" s=");
        stringBuffer.append(this.d_stdDev.toString());
        stringBuffer.append(" [");
        stringBuffer.append(this.d_min.toString());
        stringBuffer.append(", ");
        stringBuffer.append(this.d_max.toString());
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    @Override
    public UnitDouble getMin() {
        return this.d_min;
    }

    @Override
    public UnitDouble getMax() {
        return this.d_max;
    }

    @Override
    public UnitDouble getAvg() {
        return this.d_mean;
    }

    public UnitDouble getStdDev() {
        return this.d_stdDev;
    }

    @Override
    public UnitDouble getValue(Random random) {
        UnitDouble unitDouble;
        int n = 0;
        do {
            double d = random.nextGaussian();
            unitDouble = this.d_stdDev.scale(d).add(this.d_mean);
            if (++n <= 100) continue;
            return new UniformCurve(this.d_min, this.d_max).getValue(random);
        } while (unitDouble.compareTo(this.d_min) < 0 || unitDouble.compareTo(this.d_max) > 0);
        return unitDouble.convert(this.d_mean.getUnit());
    }
}

