/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.util.stat;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Random;
import org.jscience.physics.units.Unit;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.stat.ICurve;
import thunderheadeng.util.stat.UniformCurve;
import thunderheadeng.util.theUtil;

public class LogNormCurve
implements ICurve,
Serializable {
    static final long serialVersionUID = 1L;
    private final UnitDouble d_logMean;
    private final UnitDouble d_logstdev;
    private final UnitDouble d_min;
    private final UnitDouble d_max;
    @Deprecated
    private final UnitDouble d_mean = null;
    @Deprecated
    private final UnitDouble d_stdev = null;

    public LogNormCurve(UnitDouble unitDouble, UnitDouble unitDouble2, UnitDouble unitDouble3, UnitDouble unitDouble4) {
        assert (unitDouble4.getValueNoUnit() >= 0.0);
        this.d_min = unitDouble;
        this.d_max = unitDouble2;
        this.d_logMean = unitDouble3;
        this.d_logstdev = unitDouble4;
    }

    public int hashCode() {
        return 261628922 + this.d_min.hashCode() + this.d_max.hashCode() + this.d_logMean.hashCode() + this.d_logstdev.hashCode();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof LogNormCurve)) {
            return false;
        }
        LogNormCurve logNormCurve = (LogNormCurve)object;
        return this.d_min.equals(logNormCurve.d_min) && this.d_max.equals(logNormCurve.d_max) && this.d_logMean.equals(logNormCurve.d_logMean) && this.d_logstdev.equals(logNormCurve.d_logstdev);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("mu=");
        stringBuffer.append(this.d_logMean.toString());
        stringBuffer.append(" sigma=");
        stringBuffer.append(this.d_logstdev.toString());
        stringBuffer.append(" [");
        stringBuffer.append(this.d_min);
        stringBuffer.append(", ");
        stringBuffer.append(this.d_max);
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    @Override
    public UnitDouble getValue(Random random) {
        UnitDouble unitDouble;
        Unit unit = this.d_logstdev.getUnit();
        double d = this.d_logMean.getValueNoUnit();
        double d2 = this.d_logstdev.getValueNoUnit();
        int n = 0;
        do {
            double d3 = Math.sqrt(-2.0 * Math.log(random.nextDouble())) * Math.sin(Math.PI * 2 * random.nextDouble());
            d3 = Math.exp(d + d3 * d2);
            unitDouble = new UnitDouble(d3, unit);
            if (++n <= 100) continue;
            return new UniformCurve(this.d_min, this.d_max).getValue(random);
        } while (unitDouble.compareTo(this.d_min) < 0 || unitDouble.compareTo(this.d_max) > 0);
        return unitDouble;
    }

    @Deprecated
    private double getLogMean(Unit unit) {
        double d = this.d_stdev.getValue(unit) / this.d_mean.getValue(unit);
        return Math.log(this.d_mean.getValue(unit)) - 0.5 * Math.log(1.0 + d * d);
    }

    @Deprecated
    private double getLogStDev(Unit unit) {
        double d = this.d_stdev.getValue(unit) / this.d_mean.getValue(unit);
        return Math.sqrt(Math.log(1.0 + d * d));
    }

    @Override
    public UnitDouble getMax() {
        return this.d_max;
    }

    @Override
    public UnitDouble getMin() {
        return this.d_min;
    }

    @Override
    public UnitDouble getAvg() {
        return this.d_logMean;
    }

    public UnitDouble getStDev() {
        return this.d_logstdev;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        if (this.d_mean != null || this.d_stdev != null) {
            try {
                Unit unit = this.d_mean.getUnit();
                theUtil.assignFinalField(this, this.getClass(), "d_logMean", new UnitDouble(this.getLogMean(unit), unit));
                theUtil.assignFinalField(this, this.getClass(), "d_logstdev", new UnitDouble(this.getLogStDev(unit), unit));
                theUtil.assignFinalField(this, this.getClass(), "d_mean", null);
                theUtil.assignFinalField(this, this.getClass(), "d_stdev", null);
            }
            catch (Exception exception) {
                throw new IOException(exception);
            }
        }
    }

    public static void main(String[] stringArray) {
        UnitDouble unitDouble = new UnitDouble(0.0, null);
        UnitDouble unitDouble2 = new UnitDouble(15.0, null);
        UnitDouble unitDouble3 = new UnitDouble(1.46, null);
        UnitDouble unitDouble4 = new UnitDouble(0.55, null);
        LogNormCurve logNormCurve = new LogNormCurve(unitDouble, unitDouble2, unitDouble3, unitDouble4);
        Random random = new Random();
        try {
            File file = new File("C:/Users/spare/logNormOutput.txt");
            if (!file.exists()) {
                file.createNewFile();
            }
            FileWriter fileWriter = new FileWriter(file);
            BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);
            for (int i = 0; i < 10000; ++i) {
                bufferedWriter.write(String.format("%f", logNormCurve.getValue(random).getValueNoUnit()));
                bufferedWriter.newLine();
            }
            bufferedWriter.close();
        }
        catch (Exception exception) {
            System.out.println(exception.getLocalizedMessage());
        }
    }
}

