/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.util.stat;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import thunderheadeng.util.LinkedIdentityHashMap;
import thunderheadeng.util.stat.IUrn;
import thunderheadeng.util.stat.IUrnSampler;
import thunderheadeng.util.stat.Urn;
import thunderheadeng.util.theUtil;

public class InfiniteUrn<T>
implements IUrn<T>,
Serializable {
    private static final long serialVersionUID = 1L;
    private final Entry<T>[] d_ballWeights;

    public InfiniteUrn(Map<T, Double> map) {
        assert (theUtil.eq(InfiniteUrn.sumWeights(map.values()), 1.0, 1.0E-6));
        this.d_ballWeights = new Entry[map.size()];
        int n = 0;
        double d = 0.0;
        for (Map.Entry<T, Double> entry : map.entrySet()) {
            this.d_ballWeights[n++] = new Entry<T>(d, entry.getKey());
            d += entry.getValue().doubleValue();
        }
    }

    public InfiniteUrn(Object ... objectArray) {
        this(InfiniteUrn.toWeights(objectArray));
    }

    private static <T> Map<T, Double> toWeights(Object ... objectArray) {
        assert (objectArray.length % 2 == 0);
        LinkedIdentityHashMap<Object, Double> linkedIdentityHashMap = new LinkedIdentityHashMap<Object, Double>();
        for (int i = 0; i < objectArray.length; i += 2) {
            linkedIdentityHashMap.put(objectArray[i], (Double)objectArray[i + 1]);
        }
        return linkedIdentityHashMap;
    }

    public int hashCode() {
        return 0x5987FA ^ this.getWeights().hashCode();
    }

    public boolean equals(Object object) {
        return object == this || object instanceof InfiniteUrn && ((InfiniteUrn)object).getWeights().equals(this.getWeights());
    }

    public Urn<T> distribute(int n) {
        Map<T, Double> map = this.getWeights();
        ArrayList<Map.Entry<T, Double>> arrayList = new ArrayList<Map.Entry<T, Double>>(map.entrySet());
        Collections.sort(arrayList, new Comparator<Map.Entry<T, Double>>(){

            @Override
            public int compare(Map.Entry<T, Double> entry, Map.Entry<T, Double> entry2) {
                return Double.compare(entry2.getValue(), entry.getValue());
            }
        });
        ArrayList arrayList2 = new ArrayList(n);
        int n2 = n;
        for (Map.Entry entry : arrayList) {
            int n3 = (int)Math.round((Double)entry.getValue() * (double)n);
            if (n3 > n2) {
                n3 = n2;
            } else if (n3 == 0) {
                n3 = 1;
            }
            for (int i = 0; i < n3; ++i) {
                arrayList2.add(entry.getKey());
            }
            if ((n2 -= n3) > 0) continue;
            break;
        }
        while (n2 > 0) {
            arrayList2.add(((Map.Entry)arrayList.get(0)).getKey());
            --n2;
        }
        assert (arrayList2.size() == n);
        return new Urn(arrayList2);
    }

    private static double sumWeights(Collection<Double> collection) {
        double d = 0.0;
        for (Double d2 : collection) {
            assert (d2 >= 0.0);
            d += d2.doubleValue();
        }
        return d;
    }

    @Override
    public void getUnique(Collection<? super T> collection) {
        for (Entry<T> entry : this.d_ballWeights) {
            collection.add(entry.val);
        }
    }

    @Override
    public Map<T, Double> getWeights() {
        LinkedIdentityHashMap linkedIdentityHashMap = new LinkedIdentityHashMap();
        for (int i = 0; i < this.d_ballWeights.length; ++i) {
            Entry<T> entry = this.d_ballWeights[i];
            double d = i < this.d_ballWeights.length - 1 ? this.d_ballWeights[i + 1].f : 1.0;
            double d2 = d - entry.f;
            linkedIdentityHashMap.put(entry.val, d2);
        }
        return linkedIdentityHashMap;
    }

    @Override
    public T getValue(Random random) {
        double d = random.nextDouble();
        int n = Arrays.binarySearch(this.d_ballWeights, (Object)d);
        if (n < 0 && (n = -n - 2) < 0) {
            n = 0;
        }
        return this.d_ballWeights[n].val;
    }

    @Override
    public IUrnSampler<T> getSampler(Random random) {
        return new Sampler<T>(this.getWeights(), random);
    }

    public String toString() {
        return this.getWeights().toString();
    }

    public static class Sampler<T>
    implements IUrnSampler<T> {
        private final Object[] d_balls;
        private final double[] d_desiredCounts;
        private final int[] d_counts;
        private int d_iteration;
        private int d_samplingIndex;
        private T d_currBall;
        private double[] d_roundingErrors;
        private double[] d_ratios;

        public Sampler(Map<T, Double> map, Random random) {
            ArrayList<Map.Entry<T, Double>> arrayList = new ArrayList<Map.Entry<T, Double>>(map.entrySet());
            Collections.sort(arrayList, new Comparator<Map.Entry<T, Double>>(){

                @Override
                public int compare(Map.Entry<T, Double> entry, Map.Entry<T, Double> entry2) {
                    return entry2.getValue().compareTo(entry.getValue());
                }
            });
            double d = !arrayList.isEmpty() ? (Double)((Map.Entry)arrayList.get(arrayList.size() - 1)).getValue() : Double.POSITIVE_INFINITY;
            this.d_balls = new Object[arrayList.size()];
            this.d_desiredCounts = new double[arrayList.size()];
            this.d_roundingErrors = new double[arrayList.size() - 1];
            this.d_ratios = new double[arrayList.size() - 1];
            for (int i = 0; i < arrayList.size(); ++i) {
                Map.Entry entry = (Map.Entry)arrayList.get(i);
                this.d_balls[i] = entry.getKey();
                this.d_desiredCounts[i] = (Double)entry.getValue() / d;
                if (i <= 0) continue;
                this.d_ratios[i - 1] = this.d_desiredCounts[i - 1] / this.d_desiredCounts[i];
            }
            this.d_counts = new int[arrayList.size()];
            Arrays.fill(this.d_counts, 0);
            this.sampleNext();
        }

        @Override
        public T getCurrentSample() {
            return this.d_currBall;
        }

        @Override
        public T sampleNext() {
            T t = this.d_currBall;
            while (true) {
                int n;
                int n2 = this.d_counts[this.d_samplingIndex];
                int n3 = n = this.d_samplingIndex < this.d_ratios.length ? (int)Math.round(this.d_ratios[this.d_samplingIndex]) : 1;
                if (n2 == 0 && this.d_samplingIndex < this.d_roundingErrors.length) {
                    int n4 = this.d_samplingIndex;
                    this.d_roundingErrors[n4] = this.d_roundingErrors[n4] + (this.d_ratios[this.d_samplingIndex] - (double)n);
                }
                int n5 = 0;
                if (this.d_samplingIndex < this.d_roundingErrors.length) {
                    int n6 = n5 = theUtil.gt0(this.d_roundingErrors[this.d_samplingIndex], 0.0) ? (int)Math.floor(this.d_roundingErrors[this.d_samplingIndex]) : (int)Math.ceil(this.d_roundingErrors[this.d_samplingIndex]);
                }
                if (n2 < (n += n5)) {
                    this.d_currBall = this.d_balls[this.d_samplingIndex];
                    int n7 = this.d_samplingIndex;
                    this.d_counts[n7] = this.d_counts[n7] + 1;
                    if (n2 + 1 >= n) break;
                    for (int i = 0; i < this.d_samplingIndex; ++i) {
                        this.d_counts[i] = 0;
                    }
                    this.d_samplingIndex = 0;
                    break;
                }
                if (n2 == n && this.d_samplingIndex < this.d_roundingErrors.length) {
                    int n8 = this.d_samplingIndex;
                    this.d_roundingErrors[n8] = this.d_roundingErrors[n8] - (double)n5;
                }
                if (this.d_samplingIndex < this.d_balls.length - 1) {
                    ++this.d_samplingIndex;
                    continue;
                }
                Arrays.fill(this.d_counts, 0);
                this.d_samplingIndex = 0;
            }
            return t;
        }
    }

    private static class Entry<T>
    implements Comparable<Double>,
    Serializable {
        private static final long serialVersionUID = 1L;
        public final double f;
        public final T val;

        public Entry(double d, T t) {
            this.f = d;
            this.val = t;
        }

        @Override
        public int compareTo(Double d) {
            return Double.compare(this.f, d);
        }

        public boolean equals(Object object) {
            return object == this || object instanceof Entry && Objects.equals(((Entry)object).val, this.val) && ((Entry)object).f == this.f;
        }

        public int hashCode() {
            return 0x34AF938 ^ Double.hashCode(this.f) + Objects.hashCode(this.val);
        }
    }
}

