/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.util.mtproc;

import java.util.List;
import java.util.concurrent.BrokenBarrierException;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicInteger;
import thunderheadeng.util.mtproc.MTListProcessorPool;
import thunderheadeng.util.mtproc.MTListProcessorThread;

public class MTProcessor {
    private final int d_numThreads;
    private final CyclicBarrier d_endLock;
    private final AtomicInteger d_ix;
    private final Object d_guidedLock;
    private Schedule d_defSchedule;
    private Schedule d_schedule;
    private int d_guidedOffset;
    private final MTListProcessorPool d_mtlpPool;

    public MTProcessor(int n, Schedule schedule, MTListProcessorPool mTListProcessorPool) {
        this.d_endLock = new CyclicBarrier(n);
        this.d_numThreads = n;
        this.d_guidedLock = new Object();
        this.d_ix = new AtomicInteger();
        this.d_defSchedule = schedule;
        this.d_mtlpPool = mTListProcessorPool;
    }

    public int getNumThreads() {
        return this.d_numThreads;
    }

    public Schedule getDefaultSchedule() {
        return this.d_defSchedule;
    }

    public <T> void process(List<T> list, IProc<T> iProc) throws ExecutionException {
        this.process(list, iProc, this.d_defSchedule);
    }

    public <T> void process(List<? extends T> list, IProc<T> iProc, Schedule schedule) throws ExecutionException {
        this.d_ix.set(0);
        this.d_guidedOffset = 0;
        this.d_schedule = schedule;
        List<MTListProcessorThread> list2 = this.d_mtlpPool.getThreads(this.d_numThreads - 1);
        Runner<T> runner = new Runner<T>(this, list, iProc);
        for (int i = 0; i < this.d_numThreads - 1; ++i) {
            MTListProcessorThread mTListProcessorThread = list2.get(i);
            mTListProcessorThread.run(runner);
        }
        runner.run(this.d_numThreads - 1);
        if (((Runner)runner).d_caughtException != null) {
            throw new ExecutionException(((Runner)runner).d_caughtException);
        }
    }

    protected int[] getNextProcParams(int n) {
        switch (this.d_schedule) {
            case DYNAMIC: {
                return new int[]{this.d_ix.getAndIncrement(), 1};
            }
        }
        return null;
    }

    public static interface IProc<T> {
        public void process(T var1, int var2, int var3);
    }

    protected static class Runner<T>
    implements MTListProcessorThread.IRunner {
        private final MTProcessor d_processor;
        private final List<? extends T> d_list;
        private final IProc<T> d_currProc;
        private Throwable d_caughtException = null;

        public Runner(MTProcessor mTProcessor, List<? extends T> list, IProc<T> iProc) {
            this.d_processor = mTProcessor;
            this.d_list = list;
            this.d_currProc = iProc;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run(int n) {
            try {
                this.process(n);
            }
            catch (Throwable throwable) {
                Runner runner = this;
                synchronized (runner) {
                    if (this.d_caughtException == null) {
                        this.d_caughtException = throwable;
                    }
                }
            }
            try {
                this.d_processor.d_endLock.await();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
            catch (BrokenBarrierException brokenBarrierException) {
                // empty catch block
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void process(int n) {
            List<T> list = this.d_list;
            int n2 = this.d_list.size();
            int n3 = this.d_processor.getNumThreads();
            AtomicInteger atomicInteger = this.d_processor.d_ix;
            Object object = this.d_processor.d_guidedLock;
            block2 : switch (this.d_processor.d_schedule) {
                case DYNAMIC: {
                    int n4;
                    while ((n4 = atomicInteger.getAndIncrement()) < n2) {
                        this.d_currProc.process(list.get(n4), n, n4);
                    }
                    break;
                }
                case STATIC: {
                    int n5 = n2 / n3;
                    int n6 = n2 % n3;
                    if (n < n6) {
                        ++n5;
                    }
                    int n7 = n5 * n;
                    if (n >= n6) {
                        n7 += n6;
                    }
                    int n8 = n7 + n5;
                    for (int i = n7; i < n8; ++i) {
                        this.d_currProc.process(list.get(i), n, i);
                    }
                    break;
                }
                case GUIDED: {
                    block10: while (true) {
                        int n9;
                        int n10;
                        int n11;
                        Object object2 = object;
                        synchronized (object2) {
                            n11 = this.d_processor.d_guidedOffset;
                            n10 = n2 - n11;
                            n9 = (int)Math.ceil((double)n10 / (double)n3);
                            assert (n10 == 0 || n9 <= n10);
                            MTProcessor mTProcessor = this.d_processor;
                            mTProcessor.d_guidedOffset = mTProcessor.d_guidedOffset + n9;
                        }
                        if (n10 == 0) break block2;
                        int n12 = n11 + n9;
                        int n13 = n11;
                        while (true) {
                            if (n13 >= n12) continue block10;
                            this.d_currProc.process(list.get(n13), n, n13);
                            ++n13;
                        }
                        break;
                    }
                }
            }
        }
    }

    public static enum Schedule {
        DYNAMIC,
        GUIDED,
        STATIC;

    }
}

