/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.util.filters;

import java.io.Serializable;
import thunderheadeng.util.filters.ISignalFilter;

public class EQBiquadFilter
implements ISignalFilter,
Serializable {
    private static final long serialVersionUID = 1L;
    private final double b0a0;
    private final double b1a0;
    private final double b2a0;
    private final double a1a0;
    private final double a2a0;
    private double x_n1;
    private double x_n2;
    private double y_n1;
    private double y_n2;

    protected EQBiquadFilter(double d, double d2, double d3, double d4, double d5, double d6, double d7) {
        this.b0a0 = d / d4;
        this.b1a0 = d2 / d4;
        this.b2a0 = d3 / d4;
        this.a1a0 = d5 / d4;
        this.a2a0 = d6 / d4;
        this.y_n1 = this.y_n2 = d7;
        this.x_n2 = this.y_n2;
        this.x_n1 = this.y_n2;
    }

    @Override
    public double filter(double d) {
        double d2 = this.b0a0 * d + this.b1a0 * this.x_n1 + this.b2a0 * this.x_n2 - this.a1a0 * this.y_n1 - this.a2a0 * this.y_n2;
        this.x_n2 = this.x_n1;
        this.x_n1 = d;
        this.y_n2 = this.y_n1;
        this.y_n1 = d2;
        return d2;
    }

    public static EQBiquadFilter lfp(double d, double d2, double d3, double d4) {
        double d5 = Math.PI * 2 * d / d2;
        double d6 = Math.cos(d5);
        double d7 = Math.sin(d5) / (2.0 * d3);
        double d8 = (1.0 - d6) / 2.0;
        double d9 = 1.0 - d6;
        double d10 = d8;
        double d11 = 1.0 + d7;
        double d12 = -2.0 * d6;
        double d13 = 1.0 - d7;
        return new EQBiquadFilter(d8, d9, d10, d11, d12, d13, d4);
    }
}

