/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.util;

import java.awt.Component;
import java.awt.Container;
import java.util.ArrayDeque;
import thunderheadeng.util.IdentityHashSet;

public class Win32Native {
    public static final int PROXY_CONFIG_UNKNOWN = -1;
    public static final int PROXY_CONFIG_DIRECT = 0;
    public static final int PROXY_CONFIG_NAMED = 1;

    public static native void allowSetForegroundWindow(int var0);

    public static ProxyConfig getProxyConfig() {
        try {
            return Win32Native.jniGetProxyConfig();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    private static native ProxyConfig jniGetProxyConfig();

    private static int findi(String[] stringArray, String string) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equalsIgnoreCase(string)) continue;
            return i;
        }
        return -1;
    }

    public static void setJVMDefaultProxyProps(ProxyConfig proxyConfig) {
        if (proxyConfig.type == -1 || proxyConfig.type == 0) {
            return;
        }
        String[] stringArray = proxyConfig.proxy.split("[=:;]");
        if (stringArray.length == 1) {
            System.setProperty("http.proxyHost", stringArray[0]);
            System.setProperty("https.proxyHost", stringArray[0]);
        } else if (stringArray.length == 2) {
            System.setProperty("http.proxyHost", stringArray[0]);
            System.setProperty("http.proxyPort", stringArray[1]);
            System.setProperty("https.proxyHost", stringArray[0]);
            System.setProperty("https.proxyPort", stringArray[1]);
        } else {
            String string;
            String string2;
            int n = Win32Native.findi(stringArray, "http");
            int n2 = Win32Native.findi(stringArray, "https");
            if (n != -1) {
                string2 = stringArray[n + 1];
                string = stringArray.length > n + 2 ? stringArray[n + 2] : "";
                System.setProperty("http.proxyHost", string2);
                System.setProperty("http.proxyPort", string);
                System.setProperty("https.proxyHost", string2);
                System.setProperty("https.proxyPort", string);
            }
            if (n2 != -1) {
                string2 = stringArray[n2 + 1];
                string = stringArray.length > n2 + 2 ? stringArray[n2 + 2] : "";
                System.setProperty("https.proxyHost", string2);
                System.setProperty("https.proxyPort", string);
            }
        }
    }

    public static native long getHwnd(Component var0);

    public static long findHwnd(Component component) {
        ArrayDeque<Component> arrayDeque = new ArrayDeque<Component>();
        arrayDeque.addFirst(component);
        IdentityHashSet identityHashSet = new IdentityHashSet();
        identityHashSet.add(component);
        while (!arrayDeque.isEmpty()) {
            long l;
            Component component2 = (Component)arrayDeque.removeFirst();
            if (!component2.isLightweight() && (l = Win32Native.getHwnd(component2)) != 0L) {
                return l;
            }
            Container container = component2.getParent();
            if (container == null || !identityHashSet.add(container)) continue;
            arrayDeque.addLast(container);
        }
        return 0L;
    }

    public static class ProxyConfig {
        public int type = -1;
        public String proxy = "";
    }
}

