/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.util;

import java.awt.GridBagLayout;
import java.awt.Window;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.function.Supplier;
import javax.swing.JComponent;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import thunderheadeng.Intl;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.HTMLLabel;
import thunderheadeng.gui.guiCheckBox;
import thunderheadeng.gui.guiDialog;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.io.UrlDataLoader;
import thunderheadeng.license3.LicenseManager;

public class VersionUtil {
    private static CheckForUpdatesPnl buildFailedStatusPanel() {
        CheckForUpdatesPnl checkForUpdatesPnl = new CheckForUpdatesPnl();
        checkForUpdatesPnl.setConnectionStatus(false);
        checkForUpdatesPnl.setLayout(new GridBagLayout());
        GridBagHelper gridBagHelper = new GridBagHelper(checkForUpdatesPnl);
        guiLabel guiLabel2 = new guiLabel(Intl.intl("Unable to connect to server."));
        gridBagHelper.addRow(guiLabel2);
        gridBagHelper.finalizeRows();
        return checkForUpdatesPnl;
    }

    public static CheckForUpdatesPnl buildPanel(LicenseManager licenseManager, String string, IVersionSource iVersionSource) {
        Supplier<String> supplier = () -> licenseManager.getLicenseVersion();
        return VersionUtil.buildPanel(supplier, string, iVersionSource);
    }

    public static CheckForUpdatesPnl buildPanel(Supplier<String> supplier, String string, IVersionSource iVersionSource) {
        List<RevisionDesc> list = iVersionSource.getRevisions();
        if (list == null) {
            return VersionUtil.buildFailedStatusPanel();
        }
        RevisionDesc revisionDesc = new RevisionDesc(supplier.get() + "99", null, null);
        Collections.sort(list, RevisionDesc.getComparator());
        RevisionDesc[] revisionDescArray = new RevisionDesc[list.size()];
        list.toArray(revisionDescArray);
        int n = Arrays.binarySearch(revisionDescArray, revisionDesc, RevisionDesc.getComparator());
        int n2 = Arrays.binarySearch(revisionDescArray, new RevisionDesc(string, null, null), RevisionDesc.getComparator());
        int n3 = 0;
        int n4 = n;
        int n5 = n2;
        if (n < 0) {
            n4 = -1 * (n + 1);
        }
        if (n2 < 0) {
            n5 = -1 * (n5 + 1);
        }
        CheckForUpdatesPnl checkForUpdatesPnl = new CheckForUpdatesPnl();
        checkForUpdatesPnl.setLayout(new GridBagLayout());
        GridBagHelper gridBagHelper = new GridBagHelper(checkForUpdatesPnl);
        if (n5 == 0) {
            guiLabel guiLabel2 = new guiLabel(String.format(Intl.intl("You are using the latest version of %s."), iVersionSource.getProductName()));
            gridBagHelper.addRow(guiLabel2);
            checkForUpdatesPnl.setUpToDate(true);
        } else if (n5 <= n4 && RevisionDesc.getComparator().compare(new RevisionDesc(string, null, null), revisionDesc) > 0) {
            guiLabel guiLabel3 = new guiLabel(Intl.intl("You are using the latest version supported by your license."));
            guiLabel guiLabel4 = new guiLabel(Intl.intl("A newer version is available:"));
            String string2 = String.format("<a href=%s>%s</a> - <i>%s</i>", list.get((int)n3).address, list.get((int)n3).name, list.get(n3).getReleaseDate());
            HTMLLabel hTMLLabel = new HTMLLabel(string2);
            gridBagHelper.addRow(guiLabel3);
            gridBagHelper.addRow(guiLabel4);
            gridBagHelper.addIdentRow(hTMLLabel);
        } else if (n5 > 0 && n5 > n4 && n4 == n3) {
            guiLabel guiLabel5 = new guiLabel(Intl.intl("You are not using the latest version supported by your license."));
            guiLabel guiLabel6 = new guiLabel(Intl.intl("A free upgrade is available:"));
            String string3 = String.format("<a href=%s>%s</a> - <i>%s</i>", list.get((int)n4).address, list.get((int)n4).name, list.get(n4).getReleaseDate());
            HTMLLabel hTMLLabel = new HTMLLabel(string3);
            gridBagHelper.addRow(guiLabel5);
            gridBagHelper.addRow(guiLabel6);
            gridBagHelper.addIdentRow(hTMLLabel);
        } else {
            guiLabel guiLabel7 = new guiLabel(Intl.intl("You are not using the latest version supported by your license."));
            guiLabel guiLabel8 = new guiLabel(Intl.intl("A free upgrade is available:"));
            String string4 = String.format("<a href=%s>%s</a> - <i>%s</i>", list.get((int)n4).address, list.get((int)n4).name, list.get(n4).getReleaseDate());
            HTMLLabel hTMLLabel = new HTMLLabel(string4);
            guiLabel guiLabel9 = new guiLabel(Intl.intl("A newer version is available:"));
            String string5 = String.format("<a href=%s>%s</a> - <i>%s</i>", list.get((int)n3).address, list.get((int)n3).name, list.get(n3).getReleaseDate());
            HTMLLabel hTMLLabel2 = new HTMLLabel(string5);
            gridBagHelper.addRow(guiLabel7);
            gridBagHelper.addRow(guiLabel8);
            gridBagHelper.addIdentRow(hTMLLabel);
            gridBagHelper.addRowSpace(0);
            gridBagHelper.addRow(guiLabel9);
            gridBagHelper.addIdentRow(hTMLLabel2);
        }
        gridBagHelper.finalizeRows();
        return checkForUpdatesPnl;
    }

    public static void main(String[] stringArray) {
        MockCheckForUpdatesDlg mockCheckForUpdatesDlg = new MockCheckForUpdatesDlg();
        if (mockCheckForUpdatesDlg.doModal() == 1) {
            System.out.println("OK clicked");
        }
    }

    private static class MockCheckForUpdatesDlg
    extends ACheckForUpdatesDlg {
        public MockCheckForUpdatesDlg() {
            super((Window)null, "Check for Updates", false);
        }

        @Override
        protected void init(boolean bl) {
            this.d_updates = VersionUtil.buildPanel(() -> "2018.2.0110", "2018.1.1214", (IVersionSource)new LocalVersionSource("D:\\version.json", "MockProduct"));
            guiPanel guiPanel2 = this.getDialogPane();
            guiPanel2.add(this.d_updates);
            this.pack();
        }
    }

    public static class URLVersionSource
    extends AVersionSource {
        private final String d_url;

        public URLVersionSource(String string, String string2) {
            super(string2);
            this.d_url = string;
        }

        @Override
        public List<RevisionDesc> getRevisions() {
            try {
                UrlDataLoader urlDataLoader = new UrlDataLoader(new URL(this.d_url), UrlDataLoader.BLIND_HOSTNAME_VERIFIER, UrlDataLoader.BLIND_TRUST_MANAGER);
                String string = urlDataLoader.connectAndRead();
                return this.parseVersionFile(string);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return null;
            }
        }
    }

    public static class LocalVersionSource
    extends AVersionSource {
        private final String d_fileName;

        public LocalVersionSource(String string, String string2) {
            super(string2);
            this.d_fileName = string;
        }

        @Override
        public List<RevisionDesc> getRevisions() {
            try {
                byte[] byArray = Files.readAllBytes(Paths.get(this.d_fileName, new String[0]));
                String string = new String(byArray);
                return this.parseVersionFile(string);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return null;
            }
        }
    }

    private static abstract class AVersionSource
    implements IVersionSource {
        protected final String d_product;

        protected AVersionSource(String string) {
            this.d_product = string;
        }

        @Override
        public String getProductName() {
            return this.d_product;
        }

        protected List<RevisionDesc> parseVersionFile(String string) {
            try {
                JSONParser jSONParser = new JSONParser();
                JSONObject jSONObject = (JSONObject)jSONParser.parse(string);
                JSONArray jSONArray = (JSONArray)jSONObject.get((Object)this.d_product.toLowerCase());
                ArrayList<RevisionDesc> arrayList = new ArrayList<RevisionDesc>();
                for (JSONObject jSONObject2 : jSONArray) {
                    arrayList.add(new RevisionDesc((String)jSONObject2.get((Object)"revision"), (String)jSONObject2.get((Object)"address"), (String)jSONObject2.get((Object)"date")));
                }
                return arrayList;
            }
            catch (ParseException parseException) {
                parseException.printStackTrace();
                return null;
            }
        }
    }

    public static interface IVersionSource {
        public List<RevisionDesc> getRevisions();

        public String getProductName();
    }

    private static class RevisionDesc {
        public final String name;
        public final String address;
        public final String readableDate;
        public final int year;
        public final int ordinal;
        public final int date;

        public RevisionDesc(String string, String string2, String string3) {
            this.name = string;
            this.address = string2;
            this.readableDate = string3;
            String[] stringArray = string.split("\\.");
            if (stringArray.length == 3) {
                this.year = Integer.parseInt(stringArray[0]);
                this.ordinal = Integer.parseInt(stringArray[1]);
                this.date = Integer.parseInt(stringArray[2]);
            } else if (stringArray.length == 2) {
                this.year = Integer.parseInt(stringArray[0]);
                this.date = Integer.parseInt(stringArray[1]);
                this.ordinal = -1;
            } else {
                this.year = Integer.parseInt(stringArray[0]);
                this.ordinal = Integer.parseInt(stringArray[1]);
                this.date = Integer.parseInt(stringArray[2]);
            }
        }

        public String getReleaseDate() {
            return this.readableDate;
        }

        public static Comparator<RevisionDesc> getComparator() {
            return (revisionDesc, revisionDesc2) -> {
                int n = Integer.compare(revisionDesc2.year, revisionDesc.year);
                if (n != 0) {
                    return n;
                }
                if (revisionDesc.ordinal > 0 && revisionDesc2.ordinal > 0 && (n = Integer.compare(revisionDesc2.ordinal, revisionDesc.ordinal)) != 0) {
                    return n;
                }
                n = Integer.compare(revisionDesc2.date, revisionDesc.date);
                return n;
            };
        }

        public boolean equals(Object object) {
            if (!(object instanceof RevisionDesc)) {
                return false;
            }
            return this.name.equals(((RevisionDesc)object).name);
        }
    }

    private static class CheckForUpdatesPnl
    extends guiPanel {
        private guiCheckBox d_checkOnStart = new guiCheckBox(Intl.intl("Check for newer version on startup"));
        private boolean d_isUpToDate;
        private boolean d_connectionStatus;

        public CheckForUpdatesPnl() {
            this.setUpToDate(false);
            this.setConnectionStatus(true);
        }

        public JComponent getCheckBoxComponent() {
            return this.d_checkOnStart;
        }

        public void setCheckOnStartStatus(boolean bl) {
            this.d_checkOnStart.setSelected(bl);
        }

        public void setUpToDate(boolean bl) {
            this.d_isUpToDate = bl;
        }

        public void setConnectionStatus(boolean bl) {
            this.d_connectionStatus = bl;
        }

        public boolean isUpToDate() {
            return this.d_isUpToDate;
        }

        public boolean isConnected() {
            return this.d_connectionStatus;
        }

        public boolean isCheckOnStart() {
            return this.d_checkOnStart.isSelected();
        }
    }

    public static abstract class ACheckForUpdatesDlg
    extends guiDialog {
        protected CheckForUpdatesPnl d_updates;
        protected guiCheckBox d_checkOnStartCB = new guiCheckBox(Intl.intl("Check for newer version on startup"));

        protected guiPanel getMainPnl() {
            return this.d_updates;
        }

        public ACheckForUpdatesDlg(Window window, String string, boolean bl) {
            super(window, string, 1);
            this.init(bl);
        }

        public boolean isUpToDate() {
            return this.d_updates.isUpToDate();
        }

        public boolean isConnected() {
            return this.d_updates.isConnected();
        }

        public boolean isCheckOnStart() {
            return this.d_checkOnStartCB.isSelected();
        }

        protected abstract void init(boolean var1);
    }
}

