/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;

public class UncUtil {
    public static boolean isShared(String string) throws IOException {
        return UncUtil.isShared(string, UncUtil.buildSharedMap());
    }

    private static boolean iStartsWith(String string, String string2) {
        if (string == null) {
            return string2 == null;
        }
        if (string2 == null) {
            return false;
        }
        return string.toLowerCase().startsWith(string2.toLowerCase());
    }

    private static String iReplaceFirst(String string, String string2, String string3) {
        int n = string.toLowerCase().indexOf(string2.toLowerCase());
        if (n == -1) {
            return string;
        }
        String string4 = string.substring(0, n);
        String string5 = string.substring(n + string2.length());
        return string4 + string3 + string5;
    }

    public static boolean isShared(String string, Map<String, String> map) {
        if (!string.contains("\\")) {
            string = string + "\\";
        }
        Set<String> set = map.keySet();
        for (String string2 : set) {
            if (!UncUtil.iStartsWith(string, string2)) continue;
            return true;
        }
        return false;
    }

    public static String convertToLocal(String string) throws IOException {
        return UncUtil.convertToLocal(string, UncUtil.buildSharedMap());
    }

    public static String convertToLocal(String string, Map<String, String> map) {
        if (string == null || !string.startsWith("\\\\")) {
            return string;
        }
        String string2 = null;
        for (Map.Entry<String, String> entry : map.entrySet()) {
            if (!UncUtil.iStartsWith(string, entry.getValue())) continue;
            String string3 = entry.getKey() + string.substring(entry.getValue().length());
            if (string2 != null && string3.length() >= string2.length()) continue;
            string2 = string3;
        }
        return string2 != null ? string2 : string;
    }

    public static String convertToUnc(String string) throws IOException {
        return UncUtil.convertToUnc(string, UncUtil.buildSharedMap());
    }

    public static String convertToUnc(String string, Map<String, String> map) {
        if (!string.contains("\\")) {
            string = string + "\\";
        }
        ArrayList<String> arrayList = new ArrayList<String>(map.keySet());
        Collections.sort(arrayList, new LengthSorter());
        for (int i = 0; i < arrayList.size(); ++i) {
            String string2 = (String)arrayList.get(i);
            if (!UncUtil.iStartsWith(string, string2)) continue;
            String string3 = map.get(string2);
            string = UncUtil.iReplaceFirst(string, string2, string3);
            return string;
        }
        return string;
    }

    public static Map<String, String> buildSharedMap() throws IOException {
        StringBuffer stringBuffer;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        try {
            stringBuffer = new StringBuffer();
            UncUtil.execBlocking(Arrays.asList("powershell.exe", "-Command", "\"& {get-WmiObject -class Win32_Share -filter 'Type = 0' | select Path, Name | ConvertTo-Csv}\""), stringBuffer, System.err, 10000);
            UncUtil.addMapEntriesFromCsv(hashMap, stringBuffer.toString(), true);
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
        try {
            stringBuffer = new StringBuffer();
            UncUtil.execBlocking(Arrays.asList("powershell.exe", "-Command", "\"& {get-WmiObject -class Win32_MappedLogicalDisk | select Name, ProviderName | ConvertTo-Csv}\""), stringBuffer, System.err, 10000);
            UncUtil.addMapEntriesFromCsv(hashMap, stringBuffer.toString(), false);
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
        return hashMap;
    }

    private static void execBlocking(List<String> list, Appendable appendable, Appendable appendable2, int n) throws IOException, InterruptedException {
        ProcessBuilder processBuilder = new ProcessBuilder(list);
        Process process = processBuilder.start();
        process.getOutputStream().close();
        Thread thread = new Thread(() -> UncUtil.consume(process.getInputStream(), appendable));
        thread.start();
        Thread thread2 = new Thread(() -> UncUtil.consume(process.getErrorStream(), appendable2));
        thread2.start();
        if (!process.waitFor(n, TimeUnit.MILLISECONDS)) {
            System.err.println("[UncUtil] process time out");
            process.destroyForcibly();
        }
        thread.interrupt();
        thread2.interrupt();
        thread.join();
        thread2.join();
    }

    private static void consume(InputStream inputStream, Appendable appendable) {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        try {
            String string = bufferedReader.readLine();
            while (string != null) {
                appendable.append(string);
                appendable.append(System.lineSeparator());
                string = bufferedReader.readLine();
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private static void addMapEntriesFromCsv(Map<String, String> map, String string, boolean bl) throws IOException {
        if (string == null || string.isEmpty()) {
            return;
        }
        String string2 = UncUtil.getHostname();
        String[] stringArray = string.split("\\R");
        boolean bl2 = true;
        for (String string3 : stringArray) {
            if (string3.startsWith("#")) continue;
            if (bl2) {
                bl2 = false;
                continue;
            }
            String[] stringArray2 = string3.split(",(?=([^\"]*\"[^\"]*\")*[^\"]*$)");
            if (stringArray2.length != 2) continue;
            String string4 = stringArray2[0].replaceAll("^\"|\"$", "");
            String string5 = stringArray2[1].replaceAll("^\"|\"$", "");
            if (string4.isEmpty() || string5.isEmpty()) continue;
            if (bl) {
                string5 = string5.contains(":") ? String.format("\\\\%s\\%s", string2, string5.substring(string5.indexOf(":") + 2)) : String.format("\\\\%s\\%s", string2, string5);
            }
            map.put(string4, string5);
        }
    }

    private static String getHostname() throws IOException {
        InetAddress inetAddress = InetAddress.getLocalHost();
        String string = inetAddress.getHostName();
        return string;
    }

    public static void main(String[] stringArray) {
        List<String> list = Arrays.asList("C:\\Users\\spare\\Desktop\\MyGreatStuff\\woot.text", "C:\\my share\\my stuff\\secrets\\DONTreadMe.txt", "Y:\\multi_mesh.psm", "Z:", "\\\\squall\\Users\\", "\\\\autumn\\my share\\untitled\\untitled.psm", "C:\\Users\\thornton\\Desktop\\case-26895\\untitled.psm", "\\\\tempest\\my share with space\\untitled.psm", "Z:\\temp\\case-26895\\untitled.psm", "Z:\\temp\\case-26895\\ZzZitled.psm", "");
        for (String string : list) {
            try {
                System.out.printf("isShared(\"%s\"): %s%n", string, UncUtil.isShared(string));
                System.out.printf("convertToUnc(\"%s\"): \"%s\"%n", string, UncUtil.convertToUnc(string));
                System.out.printf("convertToLocal(\"%s\"): \"%s\"%n", string, UncUtil.convertToLocal(string));
                System.out.printf("convertToLocal(convertToUnc(\"%s\")): \"%s\"%n", UncUtil.convertToUnc(string), UncUtil.convertToLocal(UncUtil.convertToUnc(string)));
                Map<String, String> map = UncUtil.buildSharedMap();
                System.out.printf("[cache] convertToUnc(\"%s\"): \"%s\"%n", string, UncUtil.convertToUnc(string, map));
                System.out.printf("[cache] convertToLocal(\"%s\"): \"%s\"%n", string, UncUtil.convertToLocal(string, map));
                System.out.printf("[cache] convertToLocal(convertToUnc(\"%s\")): \"%s\"%n", UncUtil.convertToUnc(string, map), UncUtil.convertToLocal(UncUtil.convertToUnc(string, map)));
                System.out.println();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    private static class LengthSorter
    implements Comparator<Object> {
        private LengthSorter() {
        }

        @Override
        public int compare(Object object, Object object2) {
            if (object.equals(object2)) {
                return 0;
            }
            if (((String)object).length() < ((String)object2).length()) {
                return 1;
            }
            return -1;
        }
    }
}

