/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.util;

import java.text.ParseException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.Global;
import thunderheadeng.util.TypedProp;

public class TextProps {
    private static final Map<Class, IParser> s_parsers = new HashMap<Class, IParser>();

    public static <T> IParser<T> getParser(TypedProp<T> typedProp) {
        return TextProps.getParser(typedProp.type);
    }

    public static <T> IParser<T> getParser(Class<T> clazz) {
        return s_parsers.get(clazz);
    }

    public static <T> Function<T, String> getFormatter(TypedProp<T> typedProp) {
        return TextProps.getFormatter(typedProp.type);
    }

    public static <T> Function<T, String> getFormatter(Class<T> clazz) {
        return object -> object == null ? null : object.toString();
    }

    static {
        s_parsers.put(Boolean.class, string -> Boolean.valueOf(string));
        s_parsers.put(Integer.class, string -> Integer.parseInt(string));
        s_parsers.put(Long.class, string -> Long.parseLong(string));
        s_parsers.put(Float.class, string -> Float.valueOf(Float.parseFloat(string)));
        s_parsers.put(Double.class, string -> Double.parseDouble(string));
        s_parsers.put(String.class, string -> string);
        s_parsers.put(UnitDouble.class, string -> Global.parseUnitDouble(string, null, Locale.US));
    }

    public static interface IParser<T> {
        public T parse(String var1) throws ParseException;
    }
}

