/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.util;

import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.function.Function;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.IPropertySet;
import thunderheadeng.util.TextProps;
import thunderheadeng.util.TypedProp;

public class TeciProps
extends Properties
implements IPropertySet {
    public TeciProps() {
    }

    public TeciProps(Properties properties) {
        super(properties);
    }

    public boolean partialEquals(Properties properties) {
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            Object object = this.get(entry.getKey());
            if (Objects.equals(object, entry.getValue())) continue;
            return false;
        }
        return true;
    }

    @Override
    public <T> boolean isDefined(IPropertySet.Prop<T> prop) {
        return this.containsKey(prop.key);
    }

    protected <T> T get(String string, T t, Class<T> clazz) {
        return this.get(t == null ? new TypedProp<T>((Object)string, clazz) : new TypedProp<T>((Object)string, t));
    }

    @Override
    public <T> T get(IPropertySet.Prop<T> prop) {
        assert (prop instanceof TypedProp);
        return this.get((TypedProp)prop);
    }

    public <T> T get(TypedProp<T> typedProp) {
        return this.get(typedProp, TextProps.getParser(typedProp));
    }

    public <T> T get(IPropertySet.Prop<T> prop, TextProps.IParser<T> iParser) {
        String string = this.getProperty((String)prop.key);
        if (string == null) {
            return prop.defVal;
        }
        if (iParser == null) {
            return prop.defVal;
        }
        try {
            return iParser.parse(string);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return prop.defVal;
        }
    }

    public boolean getBoolean(String string, boolean bl) {
        return this.get(string, bl, Boolean.class);
    }

    public boolean getBoolean(IPropertySet.Prop<Boolean> prop) {
        return this.get(prop);
    }

    public int getInt(String string, int n) {
        return this.get(string, n, Integer.class);
    }

    public int getInt(IPropertySet.Prop<Integer> prop) {
        return this.get(prop);
    }

    public long getLong(String string, long l) {
        return this.get(string, l, Long.class);
    }

    public long getLong(IPropertySet.Prop<Long> prop) {
        return this.get(prop);
    }

    public float getFloat(String string, float f) {
        return this.get(string, Float.valueOf(f), Float.class).floatValue();
    }

    public float getFloat(IPropertySet.Prop<Float> prop) {
        return this.get(prop).floatValue();
    }

    public double getDouble(String string, double d) {
        return this.get(string, d, Double.class);
    }

    public double getDouble(IPropertySet.Prop<Double> prop) {
        return this.get(prop);
    }

    public String getString(String string, String string2) {
        return this.get(string, string2, String.class);
    }

    public String getString(IPropertySet.Prop<String> prop) {
        return this.get(prop);
    }

    public UnitDouble getUnitDouble(IPropertySet.Prop<UnitDouble> prop) {
        return this.get(prop);
    }

    public UnitDouble getUnitDouble(String string, UnitDouble unitDouble) {
        return this.get(string, unitDouble, UnitDouble.class);
    }

    @Override
    public <T> void set(IPropertySet.Prop<T> prop, T t) {
        if (prop instanceof TypedProp) {
            this.set((TypedProp)prop, t);
        } else {
            this.set(prop.key.toString(), t);
        }
    }

    public <T> void set(TypedProp<T> typedProp, T t) {
        this.set(typedProp, t, TextProps.getFormatter(typedProp));
    }

    public <T> void set(IPropertySet.Prop<T> prop, T t, Function<T, String> function) {
        String string = function.apply(t);
        this.setProperty(prop.key.toString(), string);
    }

    public void set(String string, Object object) {
        this.setProperty(string, object == null ? null : object.toString());
    }

    @Override
    public <T> void remove(IPropertySet.Prop<T> prop) {
        this.remove(prop.key);
    }

    public static class Prop {
    }
}

