/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.util;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import thunderheadeng.util.theUtil;

public class SortCache<T>
implements Serializable,
Iterable<T> {
    static final long serialVersionUID = 1L;
    private ArrayList<T> d_ixObjMap;
    private Map<T, Integer> d_objIxMap;

    public SortCache(Collection<? extends T> collection, Comparator<T> comparator) {
        this(theUtil.sort(comparator, collection));
    }

    public SortCache(Collection<? extends T> collection) {
        this(collection, true);
    }

    public SortCache(Collection<? extends T> collection, boolean bl) {
        this.d_objIxMap = bl ? new IdentityHashMap(collection.size()) : new HashMap(collection.size());
        this.d_ixObjMap = new ArrayList(collection.size());
        int n = 0;
        for (T t : collection) {
            this.d_objIxMap.put(t, n++);
            this.d_ixObjMap.add(t);
        }
        this.d_ixObjMap.trimToSize();
    }

    public T get(int n) {
        return this.d_ixObjMap.get(n);
    }

    public int indexOf(T t) {
        Integer n = this.d_objIxMap.get(t);
        return n == null ? -1 : n;
    }

    public int find(T t, Comparator<T> comparator) {
        return theUtil.binarySearch(this.d_ixObjMap, t, comparator);
    }

    public int findGeneric(Object object, Comparator<Object> comparator) {
        return theUtil.binarySearch(this.d_ixObjMap, object, comparator);
    }

    public int size() {
        return this.d_ixObjMap.size();
    }

    @Override
    public Iterator<T> iterator() {
        return this.d_ixObjMap.iterator();
    }
}

