/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.util;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Hashtable;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import thunderheadeng.util.LinkedIdentityHashSet;
import thunderheadeng.util.Predicates;
import thunderheadeng.util.theUtil;

public class SetMetrics
implements Serializable,
Cloneable {
    public static final long serialVersionUID = 1L;
    private final Hashtable<Class, Set<Object>> d_hash = new Hashtable();
    private final boolean d_identityHashes;

    public SetMetrics() {
        this(Collections.EMPTY_SET);
    }

    public SetMetrics(Collection collection) {
        this(collection, true);
    }

    public SetMetrics(boolean bl) {
        this(Collections.EMPTY_SET, bl);
    }

    public SetMetrics(Collection collection, boolean bl) {
        this.d_identityHashes = bl;
        for (Object e : collection) {
            this.add(e);
        }
    }

    protected <T> Set<T> newSet() {
        return this.d_identityHashes ? new LinkedIdentityHashSet() : new LinkedHashSet();
    }

    public boolean add(Object object) {
        return this.addEntry(object.getClass(), object);
    }

    public boolean contains(Object object) {
        Set<Object> set = this.d_hash.get(object.getClass());
        if (set != null) {
            return set.contains(object);
        }
        return false;
    }

    public boolean remove(Object object) {
        return this.removeEntry(object.getClass(), object);
    }

    public void clear() {
        this.d_hash.clear();
    }

    private boolean removeEntry(Class clazz, Object object) {
        Set<Object> set = this.d_hash.get(clazz);
        if (set == null) {
            return false;
        }
        boolean bl = set.remove(object);
        if (set.isEmpty()) {
            this.d_hash.remove(clazz);
        }
        return bl;
    }

    private boolean addEntry(Class clazz, Object object) {
        Set<Object> set = this.d_hash.get(clazz);
        if (set == null) {
            set = this.newSet();
            this.d_hash.put(clazz, set);
        }
        return set.add(object);
    }

    public <T> Set<T> filter(Class<? extends T> ... classArray) {
        return this.filter(new DefFilter<T>(classArray));
    }

    public <T> Set<T> filter(IFilter<T> iFilter) {
        Set<T> set = this.newSet();
        for (Map.Entry<Class, Set<Object>> entry : this.d_hash.entrySet()) {
            for (Class<T> clazz : iFilter.getClazzes()) {
                if (!clazz.isAssignableFrom(entry.getKey())) continue;
                for (Object object : entry.getValue()) {
                    T t = clazz.cast(object);
                    if (!iFilter.objectPasses(t)) continue;
                    set.add(t);
                }
            }
        }
        return set;
    }

    public <T> boolean isEmpty(IFilter<T> iFilter) {
        for (Map.Entry<Class, Set<Object>> entry : this.d_hash.entrySet()) {
            for (Class<T> clazz : iFilter.getClazzes()) {
                if (!clazz.isAssignableFrom(entry.getKey())) continue;
                for (Object object : entry.getValue()) {
                    if (!iFilter.objectPasses(clazz.cast(object))) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public <T> int count(IFilter<T> iFilter) {
        int n = 0;
        for (Map.Entry<Class, Set<Object>> entry : this.d_hash.entrySet()) {
            for (Class<T> clazz : iFilter.getClazzes()) {
                if (!clazz.isAssignableFrom(entry.getKey())) continue;
                for (Object object : entry.getValue()) {
                    if (!iFilter.objectPasses(clazz.cast(object))) continue;
                    ++n;
                }
            }
        }
        return n;
    }

    public int getNum(Class ... classArray) {
        return this.count(new DefFilter(classArray));
    }

    public boolean isEmpty() {
        for (Set<Object> set : this.d_hash.values()) {
            if (set.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public boolean isExclusiveSingle(Class clazz) {
        return this.isExclusive(clazz) && this.getNum(clazz) == 1;
    }

    public <T> boolean containsAny(Class<T> clazz, Predicate<? super T> predicate) {
        for (Map.Entry<Class, Set<Object>> entry : this.d_hash.entrySet()) {
            if (!clazz.isAssignableFrom(entry.getKey()) || !entry.getValue().stream().map(object -> clazz.cast(object)).filter(predicate).findAny().isPresent()) continue;
            return true;
        }
        return false;
    }

    public <T> boolean isExclusive(Class<T> clazz, Predicate<? super T> predicate) {
        return this.isExclusive(clazz, Predicates.alwaysTrue(), predicate);
    }

    public boolean isExclusive(Class ... classArray) {
        Predicate predicate = clazz -> {
            for (Class clazz2 : classArray) {
                if (!clazz2.isAssignableFrom((Class<?>)clazz)) continue;
                return true;
            }
            return false;
        };
        return this.isExclusive(Object.class, predicate, Predicates.alwaysTrue());
    }

    public <T> boolean isExclusive(Class<T> clazz, Predicate<Class<? extends T>> predicate, Predicate<? super T> predicate2) {
        boolean bl = false;
        for (Map.Entry<Class, Set<Object>> entry : this.d_hash.entrySet()) {
            if (entry.getValue().isEmpty()) continue;
            Class clazz2 = entry.getKey();
            if (!clazz.isAssignableFrom(clazz2) || !predicate.test(clazz2)) {
                return false;
            }
            if (!entry.getValue().stream().map(object -> clazz.cast(object)).allMatch(predicate2)) {
                return false;
            }
            bl = true;
        }
        return bl;
    }

    public Collection<?> flatten() {
        return theUtil.flatMap(this.d_hash.values(), set -> set);
    }

    public SetMetrics clone() {
        try {
            SetMetrics setMetrics = (SetMetrics)super.clone();
            for (Map.Entry<Class, Set<Object>> entry : this.d_hash.entrySet()) {
                for (Object object : entry.getValue()) {
                    setMetrics.add(object);
                }
            }
            return setMetrics;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public static final class DefFilter<T>
    extends AFilter<T> {
        public DefFilter(Class<? extends T> ... classArray) {
            super(classArray);
        }

        @Override
        public final boolean objectPasses(T t) {
            return true;
        }

        @Override
        public boolean reset() {
            return false;
        }
    }

    public static abstract class AFilter<T>
    implements IFilter<T> {
        private final Class<? extends T>[] d_clazzes;

        public AFilter(Class<? extends T> ... classArray) {
            this.d_clazzes = classArray;
        }

        @Override
        public Class<? extends T>[] getClazzes() {
            return this.d_clazzes;
        }
    }

    public static interface IFilter<T> {
        public boolean objectPasses(T var1);

        public Class<? extends T>[] getClazzes();

        public boolean reset();
    }
}

