/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.util;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import thunderheadeng.util.IPropertySet;

public class PropertySet
implements IPropertySet,
Serializable,
Cloneable {
    static final long serialVersionUID = 1L;
    private Map<Object, Object> d_props = Collections.EMPTY_MAP;
    private static final Object UNMAPPED = new Object();

    protected Map<Object, Object> newMap() {
        return new HashMap<Object, Object>();
    }

    public Map<Object, Object> getMap() {
        return this.d_props;
    }

    public PropertySet clone() {
        try {
            PropertySet propertySet = (PropertySet)super.clone();
            if (propertySet.d_props != Collections.emptyMap()) {
                propertySet.d_props = this.newMap();
                propertySet.d_props.putAll(this.d_props);
            }
            return propertySet;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            assert (false);
            return null;
        }
    }

    @Override
    public <T> void set(IPropertySet.Prop<T> prop, T t) {
        this.preSet();
        this.d_props.put(prop.key, t);
    }

    private void preSet() {
        if (this.d_props == Collections.EMPTY_MAP) {
            this.d_props = this.newMap();
        }
    }

    @Override
    public <T> void remove(IPropertySet.Prop<T> prop) {
        this.remove(prop.key);
    }

    public void clear() {
        this.d_props = Collections.emptyMap();
    }

    private void remove(Object object) {
        if (!this.d_props.isEmpty()) {
            this.d_props.remove(object);
            this.postRemove();
        }
    }

    private void postRemove() {
        if (this.d_props.isEmpty()) {
            this.d_props = Collections.EMPTY_MAP;
        }
    }

    @Override
    public <T> T get(IPropertySet.Prop<T> prop) {
        return (T)this.d_props.getOrDefault(prop.key, prop.defVal);
    }

    public int size() {
        return this.d_props.size();
    }

    @Override
    public <T> void merge(IPropertySet iPropertySet, IPropertySet.Prop<T> prop) {
        if (iPropertySet instanceof PropertySet) {
            PropertySet propertySet = (PropertySet)iPropertySet;
            Object object = propertySet.d_props.getOrDefault(prop.key, UNMAPPED);
            if (object == UNMAPPED) {
                this.remove(prop);
            } else {
                this.set(prop, object);
            }
        } else {
            IPropertySet.super.merge(iPropertySet, prop);
        }
    }

    public void merge(PropertySet propertySet) {
        this.preSet();
        this.d_props.putAll(propertySet.d_props);
    }

    @Override
    public <T> boolean isDefined(IPropertySet.Prop<T> prop) {
        return this.d_props.containsKey(prop.key);
    }
}

