/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.util;

import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;

public class Property<T> {
    private static final Object NOT_SUPPORTED_VAL = new Object();
    private static final Object NON_UNIFORM_VAL = new Object();
    private static final Property N_SUPPORTED = new Property(NOT_SUPPORTED_VAL);
    private static final Property N_UNIFORM = new Property(NON_UNIFORM_VAL);
    private final Object d_val;

    private Property(Object object) {
        this.d_val = object;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Property)) {
            return false;
        }
        Property property = (Property)object;
        return Objects.equals(this.d_val, property.d_val);
    }

    public int hashCode() {
        return Objects.hashCode(this.d_val);
    }

    public boolean isUniform() {
        return this.d_val != NOT_SUPPORTED_VAL && this.d_val != NON_UNIFORM_VAL;
    }

    public boolean isSupported() {
        return this.d_val != NOT_SUPPORTED_VAL;
    }

    public T get() {
        if (this.d_val == NOT_SUPPORTED_VAL || this.d_val == NON_UNIFORM_VAL) {
            throw new NoSuchElementException("No value present");
        }
        return (T)this.d_val;
    }

    public T orElse(T t) {
        if (this.d_val == NOT_SUPPORTED_VAL || this.d_val == NON_UNIFORM_VAL) {
            return t;
        }
        return (T)this.d_val;
    }

    public T orElseGet(Supplier<T> supplier) {
        if (this.d_val == NOT_SUPPORTED_VAL || this.d_val == NON_UNIFORM_VAL) {
            return supplier.get();
        }
        return (T)this.d_val;
    }

    public <X extends Throwable> T orElseThrow(Supplier<X> supplier) throws X {
        if (this.d_val == NOT_SUPPORTED_VAL || this.d_val == NON_UNIFORM_VAL) {
            throw (Throwable)supplier.get();
        }
        return (T)this.d_val;
    }

    public void ifUniform(Consumer<T> consumer) {
        if (this.isUniform()) {
            consumer.accept(this.d_val);
        }
    }

    public <U> Property<U> map(Function<? super T, ? extends U> function) {
        if (this.d_val == NON_UNIFORM_VAL) {
            return Property.nonUniform();
        }
        if (this.d_val == NOT_SUPPORTED_VAL) {
            return Property.notSupported();
        }
        return Property.of(function.apply(this.d_val));
    }

    public <U> Property<U> flatMap(Function<? super T, Property<U>> function) {
        if (this.d_val == NON_UNIFORM_VAL) {
            return Property.nonUniform();
        }
        if (this.d_val == NOT_SUPPORTED_VAL) {
            return Property.notSupported();
        }
        return function.apply(this.d_val);
    }

    public static <T> Property<T> of(T t) {
        return new Property<T>(t);
    }

    public static <T> Property<T> ofNullable(T t) {
        if (t == null) {
            return Property.nonUniform();
        }
        return Property.of(t);
    }

    public static <T> Property<T> nonUniform() {
        return N_UNIFORM;
    }

    public static <T> Property<T> notSupported() {
        return N_SUPPORTED;
    }
}

