/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.util;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Predicate;
import thunderheadeng.util.APredicate;
import thunderheadeng.util.theUtil;

public class Predicates {
    public static final <T> Predicate<T> alwaysTrue() {
        return AlwaysTrue.INSTANCE;
    }

    public static final <T> Predicate<T> alwaysFalse() {
        return AlwaysFalse.INSTANCE;
    }

    public static final <T> boolean alwaysTrue(Predicate<T> predicate) {
        return predicate == Predicates.alwaysTrue();
    }

    public static final <T> boolean alwaysFalse(Predicate<T> predicate) {
        return predicate == Predicates.alwaysFalse();
    }

    public static final <T> Predicate<T> always(boolean bl) {
        if (bl) {
            return Predicates.alwaysTrue();
        }
        return Predicates.alwaysFalse();
    }

    public static final <T> Predicate<T> or(Predicate<T> predicate, Predicate<? super T> predicate2) {
        if (predicate2 == Predicates.alwaysTrue()) {
            return Predicates.alwaysTrue();
        }
        if (predicate2 == Predicates.alwaysFalse()) {
            return predicate;
        }
        return predicate.or(predicate2);
    }

    public static final <T> Predicate<T> or(Predicate<T> ... predicateArray) {
        if (predicateArray.length == 1) {
            return predicateArray[0];
        }
        if (predicateArray.length == 2) {
            return Predicates.or(predicateArray[0], predicateArray[1]);
        }
        return new MultiOr<T>(predicateArray);
    }

    public static final <T> Predicate<T> and(Predicate<T> predicate, Predicate<? super T> predicate2) {
        if (predicate2 == Predicates.alwaysTrue()) {
            return predicate;
        }
        if (predicate2 == Predicates.alwaysFalse()) {
            return Predicates.alwaysFalse();
        }
        return predicate.and(predicate2);
    }

    public static final <T> Predicate<T> and(Predicate<T> ... predicateArray) {
        if (predicateArray.length == 1) {
            return predicateArray[0];
        }
        if (predicateArray.length == 2) {
            return Predicates.and(predicateArray[0], predicateArray[1]);
        }
        return new MultiAnd<T>(predicateArray);
    }

    public static <T> Predicate<T> combine(Predicate<T> predicate, Predicate<T> predicate2) {
        return Predicates.and(predicate, predicate2);
    }

    protected static <T> boolean setsEqual(T[] TArray, T[] TArray2) {
        if (TArray.length != TArray2.length) {
            return false;
        }
        for (T t : TArray) {
            if (Predicates.contains(TArray2, t)) continue;
            return false;
        }
        return true;
    }

    protected static <T> boolean contains(T[] TArray, T t) {
        for (T t2 : TArray) {
            if (!theUtil.equal(t2, t)) continue;
            return true;
        }
        return false;
    }

    public static <T> Predicate<T> cache(Predicate<T> predicate) {
        if (Predicates.alwaysTrue(predicate) || Predicates.alwaysFalse(predicate)) {
            return predicate;
        }
        return new CachedFilter<T>(predicate);
    }

    public static <T> Predicate<T> parallelCache(Predicate<T> predicate) {
        if (Predicates.alwaysTrue(predicate) || Predicates.alwaysFalse(predicate)) {
            return predicate;
        }
        return new ParallelCachedFilter<T>(predicate);
    }

    public static class ParallelCachedFilter<T>
    extends APredicate<T> {
        static final long serialVersionUID = 1L;
        private final Map<T, Boolean> d_filterCache;
        private final Predicate<T> d_baseFilter;

        protected ParallelCachedFilter(Predicate<T> predicate) {
            this.d_baseFilter = predicate;
            this.d_filterCache = Collections.synchronizedMap(new HashMap());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean test(T t) {
            Map<T, Boolean> map = this.d_filterCache;
            synchronized (map) {
                Boolean bl = this.d_filterCache.get(t);
                if (bl == null) {
                    bl = this.d_baseFilter.test(t);
                    this.d_filterCache.put(t, bl);
                }
                return bl;
            }
        }

        public boolean equals(Object object) {
            return object instanceof ParallelCachedFilter && ((ParallelCachedFilter)object).d_baseFilter.equals(this.d_baseFilter);
        }

        public int hashCode() {
            return 0x239F8EAE ^ this.d_baseFilter.hashCode();
        }
    }

    public static class CachedFilter<T>
    extends APredicate<T> {
        static final long serialVersionUID = 1L;
        private final Map<T, Boolean> d_filterCache;
        private final Predicate<T> d_baseFilter;

        protected CachedFilter(Predicate<T> predicate) {
            this.d_baseFilter = predicate;
            this.d_filterCache = new HashMap<T, Boolean>();
        }

        @Override
        public boolean test(T t) {
            Boolean bl = this.d_filterCache.get(t);
            if (bl == null) {
                bl = this.d_baseFilter.test(t);
                this.d_filterCache.put(t, bl);
            }
            return bl;
        }

        public boolean equals(Object object) {
            return object instanceof CachedFilter && ((CachedFilter)object).d_baseFilter.equals(this.d_baseFilter);
        }

        public int hashCode() {
            return 0x15623 ^ this.d_baseFilter.hashCode();
        }
    }

    public static final class Negate<T>
    extends APredicate<T> {
        static final long serialVersionUID = 1L;
        public final Predicate<T> pred;

        public Negate(Predicate<T> predicate) {
            this.pred = predicate;
        }

        @Override
        public boolean test(T t) {
            return !this.pred.test(t);
        }

        public boolean equals(Object object) {
            return object == this || object instanceof Negate && ((Negate)object).pred.equals(this.pred);
        }

        public int hashCode() {
            return 0x234FE832 ^ this.pred.hashCode();
        }

        @Override
        public Predicate<T> negate() {
            return this.pred;
        }
    }

    public static class MultiOr<T>
    extends APredicate<T>
    implements Serializable {
        static final long serialVersionUID = 1L;
        public Predicate<T>[] filters;

        public MultiOr(Predicate<T> ... predicateArray) {
            this.filters = predicateArray;
        }

        public int hashCode() {
            int n = 0;
            for (Predicate<T> predicate : this.filters) {
                n += predicate.hashCode();
            }
            return n ^= 0x3498FE82;
        }

        public boolean equals(Object object) {
            return object == this || object instanceof MultiOr && Predicates.setsEqual(((MultiOr)object).filters, this.filters);
        }

        @Override
        public boolean test(T t) {
            for (Predicate<T> predicate : this.filters) {
                if (!predicate.test(t)) continue;
                return true;
            }
            return false;
        }
    }

    public static final class Or<T>
    extends APredicate<T> {
        static final long serialVersionUID = 1L;
        public final Predicate<T> pred1;
        public final Predicate<? super T> pred2;

        public Or(Predicate<T> predicate, Predicate<? super T> predicate2) {
            this.pred1 = predicate;
            this.pred2 = predicate2;
        }

        @Override
        public boolean test(T t) {
            return this.pred1.test(t) || this.pred2.test(t);
        }

        public boolean equals(Object object) {
            return object == this || object instanceof Or && (((Or)object).pred1.equals(this.pred1) && ((Or)object).pred2.equals(this.pred2) || ((Or)object).pred1.equals(this.pred2) && ((Or)object).pred2.equals(this.pred1));
        }

        public int hashCode() {
            return 0xF328FDA3 ^ this.pred1.hashCode() + this.pred2.hashCode();
        }
    }

    public static class MultiAnd<T>
    extends APredicate<T>
    implements Serializable {
        static final long serialVersionUID = 1L;
        public Predicate<T>[] filters;

        public MultiAnd(Predicate<T> ... predicateArray) {
            this.filters = predicateArray;
        }

        public int hashCode() {
            int n = 0;
            for (Predicate<T> predicate : this.filters) {
                n += predicate.hashCode();
            }
            return n ^= 0xF398FDE1;
        }

        public boolean equals(Object object) {
            return object == this || object instanceof MultiAnd && Predicates.setsEqual(((MultiAnd)object).filters, this.filters);
        }

        @Override
        public boolean test(T t) {
            for (Predicate<T> predicate : this.filters) {
                if (predicate.test(t)) continue;
                return false;
            }
            return true;
        }
    }

    public static final class And<T>
    extends APredicate<T> {
        static final long serialVersionUID = 1L;
        public final Predicate<T> pred1;
        public final Predicate<? super T> pred2;

        public And(Predicate<T> predicate, Predicate<? super T> predicate2) {
            this.pred1 = predicate;
            this.pred2 = predicate2;
        }

        @Override
        public boolean test(T t) {
            return this.pred1.test(t) && this.pred2.test(t);
        }

        public boolean equals(Object object) {
            return object == this || object instanceof And && (((And)object).pred1.equals(this.pred1) && ((And)object).pred2.equals(this.pred2) || ((And)object).pred1.equals(this.pred2) && ((And)object).pred2.equals(this.pred1));
        }

        public int hashCode() {
            return 0x2398FA32 ^ this.pred1.hashCode() + this.pred2.hashCode();
        }
    }

    private static final class AlwaysFalse<T>
    implements Predicate<T>,
    Serializable {
        static final long serialVersionUID = 1L;
        public static final AlwaysFalse INSTANCE = new AlwaysFalse();

        private AlwaysFalse() {
        }

        @Override
        public final boolean test(T t) {
            return false;
        }

        public boolean shouldFilter(T t) {
            return true;
        }

        @Override
        public final Predicate<T> or(Predicate<? super T> predicate) {
            return predicate;
        }

        @Override
        public final Predicate<T> and(Predicate<? super T> predicate) {
            return this;
        }

        @Override
        public final Predicate<T> negate() {
            return AlwaysTrue.INSTANCE;
        }

        private Object readResolve() throws ObjectStreamException {
            return INSTANCE;
        }
    }

    private static final class AlwaysTrue<T>
    implements Predicate<T>,
    Serializable {
        static final long serialVersionUID = 1L;
        public static final AlwaysTrue INSTANCE = new AlwaysTrue();

        private AlwaysTrue() {
        }

        @Override
        public final boolean test(T t) {
            return true;
        }

        public boolean shouldFilter(T t) {
            return false;
        }

        @Override
        public final Predicate<T> or(Predicate<? super T> predicate) {
            return this;
        }

        @Override
        public final Predicate<T> and(Predicate<? super T> predicate) {
            return predicate;
        }

        @Override
        public final Predicate<T> negate() {
            return AlwaysFalse.INSTANCE;
        }

        private Object readResolve() throws ObjectStreamException {
            return INSTANCE;
        }
    }
}

