/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.util;

import java.io.IOException;
import java.io.StringReader;
import java.net.URL;
import java.net.URLConnection;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import thunderheadeng.Intl;
import thunderheadeng.io.UrlDataLoader;

public class OnlineLicenseReq {
    public static Response getAuth(String string, String string2, String string3) throws IOException, ParserConfigurationException, SAXException {
        String string4 = String.format("https://www.thunderheadeng.com/auth.php?hostid=%s&key=%s&eth0=%s", string2, string, string3);
        URL uRL = new URL(string4);
        UrlDataLoader urlDataLoader = new UrlDataLoader(uRL, UrlDataLoader.BLIND_HOSTNAME_VERIFIER, UrlDataLoader.BLIND_TRUST_MANAGER);
        URLConnection uRLConnection = urlDataLoader.connect();
        int n = UrlDataLoader.getResponseCode(uRLConnection);
        Response response = new Response();
        if (n == 200) {
            String string5 = urlDataLoader.read(uRLConnection);
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(new InputSource(new StringReader(string5)));
            Node node = document.getElementsByTagName("license").item(0);
            response.err = Integer.parseInt(node.getAttributes().item(0).getTextContent());
            response.license = node.getTextContent().trim();
        } else {
            response.err = n;
            response.license = null;
        }
        return response;
    }

    public static class Response {
        public int err;
        public String license;

        public boolean isError() {
            return this.err != 0;
        }

        public String getLicenseString() {
            return this.license;
        }

        public String getErrorString() {
            switch (this.err) {
                case -10: {
                    return String.format(Intl.intl("[%d] Connection timed out"), this.err);
                }
                case -1: {
                    return String.format("[%d] %s", this.err, this.license);
                }
                case 0: {
                    return String.format(Intl.intl("[%d] Success"), this.err);
                }
                case 1: {
                    return String.format(Intl.intl("[%d] Registration key not found."), this.err);
                }
                case 10: {
                    return String.format(Intl.intl("[%d] This key has been issued to another host."), this.err);
                }
                case 11: {
                    return String.format(Intl.intl("[%d] Database Error - Unable to add \"issued\" record."), this.err);
                }
                case 12: {
                    return String.format(Intl.intl("[%d] Floating license must be installed manually."), this.err);
                }
            }
            return String.format(Intl.intl("[%d] Unknown Error"), this.err);
        }
    }
}

