/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.util;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import thunderheadeng.util.IObservable;
import thunderheadeng.util.IObserver;

public class ObservableProxy
implements IObservable {
    private final IObservable d_owner;
    private boolean d_changed;
    private int d_pauseCounter;
    private List<Object> d_observers;
    private Set<Object> d_events;

    public ObservableProxy(IObservable iObservable) {
        this.d_owner = iObservable;
        this.d_pauseCounter = 0;
        this.d_changed = false;
        this.d_observers = null;
        this.d_events = Collections.emptySet();
    }

    @Override
    public synchronized void addObserver(IObserver iObserver, boolean bl) {
        Object object;
        Object object2 = object = bl ? new WeakReference<IObserver>(iObserver) : iObserver;
        if (this.d_observers == null) {
            this.d_observers = new ArrayList<Object>(5);
        }
        this.d_observers.add(object);
    }

    @Override
    public synchronized void deleteObserver(IObserver iObserver) {
        if (this.d_observers != null) {
            Iterator<Object> iterator = this.d_observers.iterator();
            while (iterator.hasNext()) {
                Object object = iterator.next();
                if (object instanceof WeakReference) {
                    WeakReference weakReference = (WeakReference)object;
                    Object t = weakReference.get();
                    if (t != null && t != iObserver) continue;
                    iterator.remove();
                    break;
                }
                if (object != iObserver) continue;
                iterator.remove();
                break;
            }
            if (this.d_observers.isEmpty()) {
                this.d_observers = null;
            }
        }
    }

    public synchronized int countObservers() {
        return this.d_observers.size();
    }

    private synchronized void fireNotification(Set<Object> set) {
        Object[] objectArray;
        if (this.d_observers == null) {
            return;
        }
        for (Object object : objectArray = this.d_observers.toArray(new Object[this.d_observers.size()])) {
            IObserver iObserver;
            if (object instanceof WeakReference) {
                WeakReference weakReference = (WeakReference)object;
                IObserver iObserver2 = (IObserver)weakReference.get();
                if (iObserver2 == null) continue;
                iObserver = iObserver2;
            } else {
                iObserver = (IObserver)object;
            }
            if (set.isEmpty()) {
                iObserver.update(this.d_owner, null);
                continue;
            }
            for (Object e : set) {
                iObserver.update(this.d_owner, e);
            }
        }
    }

    public void pause() {
        ++this.d_pauseCounter;
    }

    public boolean resume() {
        --this.d_pauseCounter;
        assert (this.d_pauseCounter >= 0);
        return this.tryFireNotification(null);
    }

    protected boolean tryFireNotification() {
        return this.tryFireNotification(null);
    }

    protected boolean tryFireNotification(Object object) {
        if (this.d_events.isEmpty()) {
            this.d_events = Collections.singleton(object);
        } else if (this.d_events.size() > 1 || !Objects.equals(object, this.d_events.iterator().next())) {
            if (this.d_events.size() == 1) {
                this.d_events = new LinkedHashSet<Object>(this.d_events);
            }
            this.d_events.add(object);
        }
        if (this.d_pauseCounter == 0 && this.d_changed) {
            this.fireNotification(this.d_events);
            this.d_changed = false;
            this.d_events = Collections.emptySet();
            return true;
        }
        return false;
    }

    public void setChanged(boolean bl) {
        this.d_changed = bl;
        this.tryFireNotification();
    }

    public void modified(Object object) {
        this.d_changed = true;
        this.tryFireNotification(object);
    }
}

