/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import thunderheadeng.util.Filters;
import thunderheadeng.util.Pair;

public class NameGenerator
implements Serializable,
Cloneable {
    static final long serialVersionUID = 1L;
    private final String d_originalBaseName;
    private final boolean d_allowDuplicates;
    private String d_baseName;
    private int d_minNumWidth;
    private transient NumberFormat d_numFormat;
    private int d_index;
    private String d_currName;
    private transient Map<String, Integer> d_usedNames;

    public NameGenerator(String string) {
        this(string, 2, false);
    }

    public NameGenerator(String string, int n, boolean bl) {
        this(string, string, null, n, 1, bl);
    }

    public NameGenerator(String string, String string2, String string3, int n, int n2, boolean bl) {
        this.d_allowDuplicates = bl;
        this.d_originalBaseName = string;
        this.d_minNumWidth = n;
        this.d_usedNames = new HashMap<String, Integer>();
        this.d_baseName = string2;
        this.d_index = n2;
        this.d_currName = string3;
        this.initNumberFormat();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.d_usedNames = new HashMap<String, Integer>();
        this.initNumberFormat();
    }

    private void initNumberFormat() {
        int n;
        StringBuilder stringBuilder = new StringBuilder(3 + this.d_minNumWidth);
        for (n = 0; n < 3; ++n) {
            stringBuilder.append('#');
        }
        for (n = 0; n < this.d_minNumWidth; ++n) {
            stringBuilder.append('0');
        }
        this.d_numFormat = new DecimalFormat(stringBuilder.toString());
    }

    public NameGenerator clone() {
        try {
            NameGenerator nameGenerator = (NameGenerator)super.clone();
            nameGenerator.d_usedNames = new HashMap<String, Integer>(this.d_usedNames);
            return nameGenerator;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            assert (false);
            return null;
        }
    }

    public void reset() {
        this.d_usedNames.clear();
        this.d_baseName = this.d_originalBaseName;
        this.d_index = 1;
        this.d_currName = null;
    }

    public void setBaseName(String string) {
        if (string.equals(this.d_baseName)) {
            return;
        }
        this.d_baseName = string;
        this.d_index = 1;
        this.d_currName = null;
    }

    public String getBaseName() {
        return this.d_baseName;
    }

    public boolean getAllowsDuplicates() {
        return this.d_allowDuplicates;
    }

    public void registerName(String string) {
        if (this.d_allowDuplicates || string == null) {
            return;
        }
        String string2 = this.generateName();
        Integer n = this.d_usedNames.get(string);
        if (n == null) {
            n = 0;
        }
        this.d_usedNames.put(string, n + 1);
        if (string.equals(string2)) {
            this.d_currName = null;
            ++this.d_index;
        }
    }

    public void registerNames(Collection<String> collection) {
        for (String string : collection) {
            this.registerName(string);
        }
    }

    public void unregisterName(String string) {
        if (this.d_allowDuplicates || string == null) {
            return;
        }
        Integer n = this.d_usedNames.get(string);
        if (n <= 1) {
            this.d_usedNames.remove(string);
        } else {
            this.d_usedNames.put(string, n - 1);
        }
    }

    public void updateRegisteredName(String string, String string2) {
        if (this.d_allowDuplicates) {
            return;
        }
        this.unregisterName(string);
        this.registerName(string2);
    }

    public boolean isRegistered(String string) {
        return this.d_allowDuplicates ? false : this.d_usedNames.containsKey(string);
    }

    private Predicate<String> getFilter() {
        return this.getFilter(Filters.rejectAll(String.class), Filters.acceptAll(String.class));
    }

    private Predicate<String> getFilter(Predicate<String> predicate, Predicate<String> predicate2) {
        if (this.d_allowDuplicates) {
            return Filters.acceptAll();
        }
        return Filters.or(Filters.and(Filters.reject(this.d_usedNames.keySet()), predicate2), predicate);
    }

    public String generateName() {
        if (this.d_currName == null) {
            Pair<String, Integer> pair = NameGenerator.getNextName(this.d_baseName, this.d_numFormat, this.d_index, this.getFilter());
            this.d_currName = (String)pair.v1;
        }
        return this.d_currName;
    }

    public List<String> generateNames(int n) {
        return this.generateNames(n, Filters.rejectAll(String.class));
    }

    public List<String> generateNames(int n, Predicate<String> predicate) {
        return this.generateNames(n, predicate, Filters.acceptAll(String.class));
    }

    public List<String> generateNames(int n, Predicate<String> predicate, Predicate<String> predicate2) {
        ArrayList<String> arrayList = new ArrayList<String>(n);
        Predicate<String> predicate3 = this.getFilter(predicate, predicate2);
        int n2 = this.d_index;
        for (int i = 0; i < n; ++i) {
            Pair<String, Integer> pair = NameGenerator.getNextName(this.d_baseName, this.d_numFormat, n2, predicate3);
            arrayList.add((String)pair.v1);
            n2 = (Integer)pair.v2;
        }
        return arrayList;
    }

    private static Pair<String, Integer> getNextName(String string, NumberFormat numberFormat, int n, Predicate<String> predicate) {
        String string2;
        while (!predicate.test(string2 = string + numberFormat.format(n++))) {
        }
        return new Pair<String, Integer>(string2, n);
    }

    public String generateValidName(String string) {
        return this.generateValidNames(1, string, Filters.rejectAll(String.class)).get(0);
    }

    public List<String> generateValidNames(int n, String string, Predicate<String> predicate) {
        return this.generateValidNames(n, string, predicate, Filters.acceptAll(String.class));
    }

    public List<String> generateValidNames(int n, String string, Predicate<String> predicate, Predicate<String> predicate2) {
        int n2;
        if (string.isEmpty()) {
            return this.generateNames(n, predicate, predicate2);
        }
        if (this.d_allowDuplicates) {
            ArrayList<String> arrayList = new ArrayList<String>(n);
            for (int i = 0; i < n; ++i) {
                arrayList.add(string);
            }
            return arrayList;
        }
        Predicate<String> predicate3 = this.getFilter(predicate, predicate2);
        if (n == 1 && predicate3.test(string)) {
            return Arrays.asList(string);
        }
        for (n2 = string.length() - 1; n2 >= 0; --n2) {
            if (Character.isDigit(string.charAt(n2))) continue;
            string = string.substring(0, n2 + 1);
            break;
        }
        if (string.equals(this.d_baseName)) {
            return this.generateNames(n, predicate, predicate2);
        }
        n2 = 1;
        ArrayList<String> arrayList = new ArrayList<String>(n);
        for (int i = 0; i < n; ++i) {
            Pair<String, Integer> pair = NameGenerator.getNextName(string, this.d_numFormat, n2, predicate3);
            n2 = (Integer)pair.v2;
            arrayList.add((String)pair.v1);
        }
        return arrayList;
    }
}

