/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import thunderheadeng.util.MetaPool;

public class Meta
implements Serializable,
Cloneable {
    static final long serialVersionUID = 1L;
    private final MetaPool d_pool;
    private HashMap<Serializable, Serializable> d_table = new HashMap();

    protected Meta() {
        this(null);
    }

    public Meta(MetaPool metaPool) {
        this.d_pool = metaPool;
    }

    public <T extends MetaPool> T getPool() {
        return (T)this.d_pool;
    }

    public boolean isSet(Object object) {
        return this.d_table.containsKey(object);
    }

    public <T extends Serializable> T get(Serializable serializable) {
        return (T)this.d_table.get(serializable);
    }

    public <T extends Serializable> void lightSet(Serializable serializable, T t) {
        this.d_table.put(serializable, t);
    }

    public <T extends Serializable> void lightMultiSet(Serializable serializable, Serializable ... serializableArray) {
        for (Serializable serializable2 : serializableArray) {
            this.d_table.put(serializable2, serializable);
        }
    }

    public <T extends Serializable> Meta set(Serializable serializable, T t) {
        Meta meta = (Meta)this.clone();
        meta.lightSet(serializable, t);
        return this.d_pool.get(meta);
    }

    public <T extends Serializable> Meta multiSet(Serializable serializable, Serializable ... serializableArray) {
        Meta meta = (Meta)this.clone();
        meta.lightMultiSet(serializable, serializableArray);
        return this.d_pool.get(meta);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        if (this.d_pool != null) {
            this.d_pool.get(this);
        }
    }

    protected Object clone() {
        try {
            Meta meta = (Meta)super.clone();
            meta.d_table = (HashMap)this.d_table.clone();
            return meta;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            assert (false);
            return null;
        }
    }

    public int hashCode() {
        int n = 0;
        for (Map.Entry<Serializable, Serializable> entry : this.d_table.entrySet()) {
            int n2 = entry.getKey().hashCode() & 0xFFFF0000;
            if (entry.getValue() != null) {
                n2 |= entry.getValue().hashCode();
            }
            n += n2;
        }
        return n;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Meta)) {
            return false;
        }
        Meta meta = (Meta)object;
        return this == object || this.d_table.equals(meta.d_table);
    }
}

