/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.util;

import java.util.AbstractList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import thunderheadeng.util.MappedIterator;

public class MappedList<InT, OutT>
extends AbstractList<OutT> {
    private final List<InT> d_collection;
    private final Function<InT, OutT> d_transformer;
    private final Function<OutT, InT> d_invTransformer;
    private final Class<OutT> d_transformedType;

    public MappedList(List<InT> list, Function<InT, OutT> function) {
        this(list, function, null, null);
    }

    public MappedList(List<InT> list, Function<InT, OutT> function, Function<OutT, InT> function2, Class<OutT> clazz) {
        this.d_collection = list;
        this.d_transformer = function;
        this.d_invTransformer = function2;
        this.d_transformedType = clazz;
        assert (this.d_invTransformer == null || this.d_transformedType != null);
    }

    @Override
    public Iterator<OutT> iterator() {
        return new MappedIterator<InT, OutT>(this.d_collection.iterator(), this.d_transformer);
    }

    @Override
    public boolean add(OutT OutT) {
        if (this.d_invTransformer != null) {
            return this.d_collection.add(this.d_invTransformer.apply(OutT));
        }
        return super.add(OutT);
    }

    @Override
    public boolean remove(Object object) {
        if (this.d_invTransformer != null) {
            if (object == null) {
                return this.d_collection.remove(null);
            }
            if (this.d_transformedType.isInstance(object)) {
                return this.d_collection.remove(this.d_invTransformer.apply(object));
            }
            return false;
        }
        return super.remove(object);
    }

    @Override
    public boolean contains(Object object) {
        if (this.d_invTransformer != null) {
            if (object == null) {
                return this.d_collection.contains(null);
            }
            if (this.d_transformedType.isInstance(object)) {
                return this.d_collection.contains(this.d_invTransformer.apply(object));
            }
            return false;
        }
        return super.contains(object);
    }

    @Override
    public boolean isEmpty() {
        return this.d_collection.isEmpty();
    }

    @Override
    public int size() {
        return this.d_collection.size();
    }

    @Override
    public void clear() {
        this.d_collection.clear();
    }

    @Override
    public OutT get(int n) {
        return this.d_transformer.apply(this.d_collection.get(n));
    }

    @Override
    public OutT remove(int n) {
        return this.d_transformer.apply(this.d_collection.remove(n));
    }

    @Override
    public void add(int n, OutT OutT) {
        if (this.d_invTransformer != null) {
            this.d_collection.add(n, this.d_invTransformer.apply(OutT));
            return;
        }
        super.add(n, OutT);
    }
}

