/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.util;

import java.io.Serializable;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import thunderheadeng.util.Pair;
import thunderheadeng.util.theUtil;

public class ListMap<K, V>
extends AbstractMap<K, V>
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    private static final Object[] s_emptyList = new Object[0];
    private Object[] d_list = s_emptyList;

    public ListMap() {
        this(Collections.EMPTY_MAP);
    }

    public ListMap(Map<K, V> map) {
        this.putAll(map);
    }

    @Override
    public int size() {
        return this.d_list.length / 2;
    }

    @Override
    public void clear() {
        this.d_list = s_emptyList;
    }

    @Override
    public boolean containsKey(Object object) {
        return this.keyIndex(object) != -1;
    }

    @Override
    public boolean containsValue(Object object) {
        for (int i = 1; i < this.d_list.length; i += 2) {
            Object object2 = this.d_list[i];
            if (!theUtil.equal(object2, object)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Object clone() {
        try {
            return (ListMap)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    @Override
    public boolean isEmpty() {
        return this.d_list.length == 0;
    }

    @Override
    public V get(Object object) {
        return this.getOrDefault(object, null);
    }

    @Override
    public V getOrDefault(Object object, V v) {
        int n = this.keyIndex(object);
        return (V)(n != -1 ? this.d_list[n + 1] : v);
    }

    @Override
    public V put(K k, V v) {
        int n = this.keyIndex(k);
        if (n == -1) {
            this.add(k, v);
            return null;
        }
        Object object = this.d_list[n + 1];
        this.d_list[n + 1] = v;
        return (V)object;
    }

    private void add(K k, V v) {
        Object[] objectArray = new Object[this.d_list.length + 2];
        for (int i = 0; i < this.d_list.length; ++i) {
            objectArray[i] = this.d_list[i];
        }
        objectArray[objectArray.length - 2] = k;
        objectArray[objectArray.length - 1] = v;
        this.d_list = objectArray;
    }

    @Override
    public V remove(Object object) {
        int n = this.keyIndex(object);
        if (n != -1) {
            Object object2 = this.d_list[n + 1];
            this.remove(n);
            if (this.d_list.length == 0) {
                this.d_list = s_emptyList;
            }
            return (V)object2;
        }
        return null;
    }

    private void remove(int n) {
        int n2;
        Object[] objectArray = new Object[this.d_list.length - 2];
        for (n2 = 0; n2 < n; ++n2) {
            objectArray[n2] = this.d_list[n2];
        }
        for (n2 = n + 2; n2 < this.d_list.length; ++n2) {
            objectArray[n2 - 2] = this.d_list[n2];
        }
        this.d_list = objectArray;
    }

    private int keyIndex(Object object) {
        for (int i = 0; i < this.d_list.length; i += 2) {
            Object object2 = this.d_list[i];
            if (!theUtil.equal(object2, object)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return new EntrySet();
    }

    @Override
    public Set<K> keySet() {
        return new VSet(0);
    }

    @Override
    public Collection<V> values() {
        return new VSet(1);
    }

    private class VIterator<ValT>
    implements Iterator<ValT>,
    Serializable {
        private static final long serialVersionUID = 1L;
        private int d_index;

        public VIterator(int n) {
            this.d_index = n;
        }

        @Override
        public boolean hasNext() {
            return this.d_index < ListMap.this.d_list.length;
        }

        @Override
        public ValT next() {
            Object object = ListMap.this.d_list[this.d_index];
            this.d_index += 2;
            return (ValT)object;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private class VSet<ValT>
    extends AbstractSet<ValT>
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final int d_offset;

        public VSet(int n) {
            this.d_offset = n;
        }

        @Override
        public Iterator<ValT> iterator() {
            return new VIterator(this.d_offset);
        }

        @Override
        public boolean isEmpty() {
            return ListMap.this.isEmpty();
        }

        @Override
        public void clear() {
            ListMap.this.clear();
        }

        @Override
        public int size() {
            return ListMap.this.size();
        }
    }

    private static class Entry<K, V>
    extends Pair<K, V>
    implements Map.Entry<K, V>,
    Serializable {
        private static final long serialVersionUID = 1L;

        public Entry(K k, V v) {
            super(k, v);
        }

        @Override
        public K getKey() {
            return (K)this.v1;
        }

        @Override
        public V getValue() {
            return (V)this.v2;
        }

        @Override
        public V setValue(V v) {
            throw new UnsupportedOperationException();
        }
    }

    private class EntryIterator
    implements Iterator<Map.Entry<K, V>>,
    Serializable {
        private static final long serialVersionUID = 1L;
        private int d_index = 0;

        @Override
        public boolean hasNext() {
            return this.d_index < ListMap.this.d_list.length;
        }

        @Override
        public Map.Entry<K, V> next() {
            Object object = ListMap.this.d_list[this.d_index++];
            Object object2 = ListMap.this.d_list[this.d_index++];
            return new Entry<Object, Object>(object, object2);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private class EntrySet
    extends AbstractSet<Map.Entry<K, V>>
    implements Serializable {
        private static final long serialVersionUID = 1L;

        private EntrySet() {
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return new EntryIterator();
        }

        @Override
        public boolean isEmpty() {
            return ListMap.this.isEmpty();
        }

        @Override
        public void clear() {
            ListMap.this.clear();
        }

        @Override
        public int size() {
            return ListMap.this.size();
        }
    }
}

