/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.util;

import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import thunderheadeng.util.Keyable;

public class KeyGenerator {
    private static final Random s_rand = new Random();
    public static final int NO_KEY = 0;
    private final Map<Integer, WeakReference<Keyable>> d_objects = Collections.synchronizedMap(new HashMap());
    private int d_reserveKeysCount = 0;
    private Set<Integer> d_reservedKeys = new HashSet<Integer>();

    public int getNumKeys() {
        return this.d_objects.size();
    }

    public synchronized void beginReserveKeys() {
        ++this.d_reserveKeysCount;
    }

    public synchronized void endReserveKeys() {
        if (--this.d_reserveKeysCount == 0 && !this.d_reservedKeys.isEmpty()) {
            this.d_reservedKeys = new HashSet<Integer>();
        }
    }

    public Keyable get(Integer n) {
        if (n == null) {
            return null;
        }
        WeakReference<Keyable> weakReference = this.d_objects.get(n);
        return weakReference != null ? (Keyable)weakReference.get() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Integer generateKey(Keyable keyable) {
        Set<Object> set = this.isReservingKeys() ? this.d_reservedKeys : Collections.emptySet();
        int n = System.identityHashCode(keyable);
        Map<Integer, WeakReference<Keyable>> map = this.d_objects;
        synchronized (map) {
            while (n == 0 || this.d_objects.containsKey(n) || set.contains(n)) {
                n = s_rand.nextInt();
            }
            Integer n2 = n;
            this.d_objects.put(n2, new WeakReference<Keyable>(keyable));
            return n2;
        }
    }

    public void registerKey(Keyable keyable, Integer n) {
        WeakReference<Keyable> weakReference = this.d_objects.put(n, new WeakReference<Keyable>(keyable));
        assert (weakReference == null || weakReference.get() == null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean returnKey(Integer n, Keyable keyable) {
        if (n == null) {
            return false;
        }
        Object object = this.d_objects;
        synchronized (object) {
            Keyable keyable2 = this.get(n);
            if (keyable2 == null || keyable2 == keyable) {
                return this.d_objects.remove(n) != null;
            }
        }
        object = this;
        synchronized (object) {
            if (this.isReservingKeys()) {
                this.d_reservedKeys.add(n);
            }
        }
        return false;
    }

    private boolean isReservingKeys() {
        return this.d_reserveKeysCount > 0;
    }
}

