/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.util;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.IntBuffer;
import java.util.Timer;
import java.util.TimerTask;
import thunderheadeng.util.TaskProgress;

public class JniTaskProgress {
    private final ByteBuffer d_buffer;
    private final IntBuffer d_pprog;
    private final CharBuffer d_pmsg;
    private final Timer d_progressTimer;

    public JniTaskProgress(final TaskProgress taskProgress) {
        int n = 1024;
        this.d_buffer = ByteBuffer.allocateDirect(16 + 2 * n).order(ByteOrder.nativeOrder());
        ByteBuffer byteBuffer = this.d_buffer.slice().order(ByteOrder.nativeOrder());
        this.d_pprog = byteBuffer.asIntBuffer();
        int[] nArray = taskProgress.getProgress();
        byteBuffer.putInt(nArray != null ? nArray[0] : -1);
        byteBuffer.putInt(nArray != null ? nArray[1] : 0);
        byteBuffer.putInt(taskProgress.isRunning() ? 1 : 0);
        byteBuffer.putInt(0);
        this.d_pmsg = byteBuffer.asCharBuffer();
        final char[] cArray = new char[n];
        this.d_progressTimer = new Timer(false);
        this.d_progressTimer.schedule(new TimerTask(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                String string;
                int n;
                int n2;
                boolean bl = taskProgress.isRunning();
                ByteBuffer byteBuffer = JniTaskProgress.this.d_buffer;
                synchronized (byteBuffer) {
                    n2 = JniTaskProgress.this.d_pprog.get(0);
                    n = JniTaskProgress.this.d_pprog.get(1);
                    JniTaskProgress.this.d_pprog.put(2, bl ? 1 : 0);
                    int n3 = JniTaskProgress.this.d_pprog.get(3);
                    JniTaskProgress.this.d_pmsg.get(cArray, 0, n3);
                    JniTaskProgress.this.d_pmsg.position(0);
                    string = new String(cArray, 0, n3);
                }
                taskProgress.setMax(n);
                taskProgress.setProgress(n2);
                taskProgress.setMessage(string);
                if (!bl) {
                    JniTaskProgress.this.finished();
                }
            }
        }, 16L, 16L);
    }

    protected void finalize() throws Throwable {
        this.finished();
        super.finalize();
    }

    public ByteBuffer getBuffer() {
        return this.d_buffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finished() {
        ByteBuffer byteBuffer = this.d_buffer;
        synchronized (byteBuffer) {
            this.d_pprog.put(2, 0);
        }
        this.d_progressTimer.cancel();
    }
}

