/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.util;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Stream;

public interface IPropertySet {
    public <T> void set(Prop<T> var1, T var2);

    default public <T> void setIfNotDefault(Prop<T> prop, T t) {
        if (!Objects.equals(prop.defVal, t)) {
            this.set(prop, t);
        } else {
            this.remove(prop);
        }
    }

    public <T> boolean isDefined(Prop<T> var1);

    public <T> void remove(Prop<T> var1);

    public <T> T get(Prop<T> var1);

    default public void merge(IPropertySet iPropertySet, Stream<? extends Prop<?>> stream) {
        stream.forEach(prop -> this.merge(iPropertySet, (Prop<T>)((Prop)prop)));
    }

    default public void merge(IPropertySet iPropertySet, Iterator<? extends Prop<?>> iterator) {
        while (iterator.hasNext()) {
            this.merge(iPropertySet, (Prop<T>)iterator.next());
        }
    }

    default public void merge(IPropertySet iPropertySet, Collection<? extends Prop<?>> collection) {
        for (Prop<?> prop : collection) {
            this.merge(iPropertySet, (Prop<T>)prop);
        }
    }

    default public void merge(IPropertySet iPropertySet, Prop<?> ... propArray) {
        for (Prop<?> prop : propArray) {
            this.merge(iPropertySet, (Prop<T>)prop);
        }
    }

    default public <T> void merge(IPropertySet iPropertySet, Prop<T> prop) {
        if (!iPropertySet.isDefined(prop)) {
            this.remove(prop);
        } else {
            this.set(prop, iPropertySet.get(prop));
        }
    }

    default public boolean compare(IPropertySet iPropertySet, Collection<? extends Prop<?>> collection) {
        for (Prop<?> prop : collection) {
            if (Objects.equals(this.get(prop), iPropertySet.get(prop))) continue;
            return false;
        }
        return true;
    }

    default public boolean compare(IPropertySet iPropertySet, Stream<? extends Prop<?>> stream) {
        return stream.allMatch(prop -> Objects.equals(this.get((Prop)prop), iPropertySet.get((Prop)prop)));
    }

    default public int hash(Collection<? extends Prop<?>> collection) {
        int n = -131878941;
        for (Prop<?> prop : collection) {
            n += Objects.hashCode(this.get(prop));
        }
        return n;
    }

    public static List<Prop<?>> getAllDeclaredPublicStaticProps(Class clazz) {
        return IPropertySet.getAllDeclaredProps(clazz, field -> Modifier.isPublic(field.getModifiers()) && Modifier.isStatic(field.getModifiers()));
    }

    public static List<Prop<?>> getAllDeclaredProps(Class clazz, Predicate<Field> predicate) {
        ArrayList arrayList = new ArrayList();
        for (Field field : clazz.getDeclaredFields()) {
            if (!Prop.class.isAssignableFrom(field.getType()) || !predicate.test(field)) continue;
            try {
                boolean bl = field.isAccessible();
                field.setAccessible(true);
                arrayList.add((Prop)field.get(null));
                field.setAccessible(bl);
            }
            catch (Throwable throwable) {
                if (!1.$assertionsDisabled) {
                    throw new AssertionError();
                }
                throwable.printStackTrace();
            }
        }
        return arrayList;
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
    }

    public static class Prop<T> {
        public final Object key;
        public final T defVal;

        public Prop(Object object, T t) {
            this.key = object;
            this.defVal = t;
        }
    }
}

