/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.util;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import org.jscience.physics.units.NonSI;
import org.jscience.physics.units.Unit;
import thunderheadeng.Intl;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.Formatter;

public class Global {
    public static String s_engLenFormat = "ft;in;";
    public static final int NUM_DISPLAY_SIG_DIGS = 6;
    public static final Formatter FORMATTER = new Formatter(Locale.getDefault());
    private static Map<Unit, String> s_unitDisplays = new HashMap<Unit, String>();

    public static String formatFixedWidth(double d, int n) {
        return FORMATTER.formatFixedWidth(d, n);
    }

    public static String formatFloat(double d, int n) {
        return FORMATTER.formatFloat(d, n);
    }

    public static String formatSci(double d, int n) {
        return FORMATTER.formatSci(d, n);
    }

    public static String format(double d) {
        return Global.format(d, 6);
    }

    public static String format(double d, int n) {
        return FORMATTER.format(d, n);
    }

    public static String formatGraph(double d) {
        DecimalFormat decimalFormat = new DecimalFormat();
        if (Math.abs(d) == 0.0) {
            decimalFormat.applyPattern("##0.0");
        } else if (Math.abs(d) < 9999.0 && Math.abs(d) >= 100.0) {
            decimalFormat.applyPattern("###0.0");
        } else if (Math.abs(d) < 100.0 && Math.abs(d) >= 1.0) {
            decimalFormat.applyPattern("#0.00");
        } else if (Math.abs(d) < 1.0 && Math.abs(d) > 0.099) {
            decimalFormat.applyPattern("#.000");
        } else {
            decimalFormat.applyPattern("0.0##E00");
        }
        return decimalFormat.format(d);
    }

    public static double parseDouble(CharSequence charSequence) throws ParseException {
        return Global.parseDouble(charSequence, Locale.getDefault());
    }

    public static double parseDouble(CharSequence charSequence, Locale locale) throws ParseException {
        Number number;
        int n;
        NumberFormat numberFormat = NumberFormat.getInstance(locale);
        ParsePosition parsePosition = new ParsePosition(0);
        String string = charSequence.toString().toUpperCase();
        if (string.startsWith("+") && string.length() > 1) {
            string = string.substring(1);
        }
        if ((n = string.indexOf("E+")) > 0 && string.length() > n + 1) {
            string = string.substring(0, n) + "E" + string.substring(n + 2, string.length());
        }
        if ((number = numberFormat.parse(string.toUpperCase(), parsePosition)) == null || parsePosition.getIndex() != string.length()) {
            String string2 = String.format(Intl.intl("Unparseable number: %s"), charSequence);
            throw new ParseException(string2, parsePosition.getIndex());
        }
        return number.doubleValue();
    }

    public static UnitDouble parseUnitDouble(CharSequence charSequence) throws ParseException {
        return Global.parseUnitDouble(charSequence, null);
    }

    public static UnitDouble parseUnitDouble(CharSequence charSequence, Unit unit) throws ParseException {
        return Global.parseUnitDouble(charSequence, unit, Locale.getDefault());
    }

    public static UnitDouble parseUnitDouble(CharSequence charSequence, Unit unit, Locale locale) throws ParseException {
        StringTokenizer stringTokenizer = new StringTokenizer(charSequence.toString(), " ");
        int n = stringTokenizer.countTokens();
        if (n == 0) {
            return null;
        }
        if (n == 1) {
            if (unit == null) {
                unit = Unit.ONE;
            }
            String string = stringTokenizer.nextToken();
            ParseException parseException = null;
            for (int i = string.length(); i >= 1; --i) {
                double d;
                CharSequence charSequence2 = string.subSequence(0, i);
                try {
                    d = Global.parseDouble(charSequence2, locale);
                }
                catch (ParseException parseException2) {
                    if (parseException != null) continue;
                    parseException = parseException2;
                    continue;
                }
                CharSequence charSequence3 = string.subSequence(i, string.length());
                if (charSequence3.length() == 0) {
                    return new UnitDouble(d, unit);
                }
                Unit unit2 = Global.parseUnit(charSequence3, unit);
                return new UnitDouble(d, unit2);
            }
            assert (parseException != null);
            if (parseException != null) {
                throw parseException;
            }
            throw new ParseException("", 0);
        }
        String string = stringTokenizer.nextToken();
        String string2 = stringTokenizer.nextToken();
        return Global.parseUnitDouble(string, string2, unit, locale);
    }

    private static UnitDouble parseUnitDouble(CharSequence charSequence, CharSequence charSequence2, Unit unit, Locale locale) throws ParseException {
        double d = Global.parseDouble(charSequence, locale);
        Unit unit2 = Global.parseUnit(charSequence2, unit);
        return new UnitDouble(d, unit2);
    }

    private static Unit parseUnit(CharSequence charSequence, Unit unit) throws ParseException {
        try {
            return Global.tryParseUnit(charSequence, unit);
        }
        catch (ParseException parseException) {
            charSequence = Global.replaceTemp(charSequence);
            if (charSequence == null) {
                throw parseException;
            }
            try {
                return Global.tryParseUnit(charSequence, unit);
            }
            catch (ParseException parseException2) {
                throw parseException;
            }
        }
    }

    private static CharSequence replaceTemp(CharSequence charSequence) {
        StringBuilder stringBuilder = null;
        for (int i = 0; i < charSequence.length(); ++i) {
            char c = charSequence.charAt(i);
            if (!(c != 'F' && c != 'C' && c != 'R' || i != 0 && charSequence.charAt(i - 1) == '\u00b0')) {
                if (stringBuilder == null) {
                    stringBuilder = new StringBuilder();
                    stringBuilder.append(charSequence, 0, i);
                }
                stringBuilder.append('\u00b0');
                stringBuilder.append(c);
                continue;
            }
            if (stringBuilder == null) continue;
            stringBuilder.append(c);
        }
        return stringBuilder;
    }

    private static Unit tryParseUnit(CharSequence charSequence, Unit unit) throws ParseException {
        try {
            Unit unit2 = Unit.valueOf(charSequence);
            if (unit != null && !UnitDouble.areCompatible(unit2, unit)) {
                String string = String.format(Intl.intl("Invalid unit: \"%1$s\" is incompatible with \"%2$s\"."), charSequence, unit.toString());
                throw new ParseException(string, 0);
            }
            return unit2;
        }
        catch (ParseException parseException) {
            throw parseException;
        }
        catch (Throwable throwable) {
            String string = String.format(Intl.intl("Unrecognized unit: %s"), charSequence);
            throw new ParseException(string, 0);
        }
    }

    public static String format(UnitDouble unitDouble) {
        return Global.format(unitDouble.getValueNoUnit(), unitDouble.getUnit());
    }

    public static String format(double d, Unit unit) {
        String string;
        String string2 = Global.format(d);
        String string3 = string = unit != null ? unit.toString() : "";
        if (string.isEmpty()) {
            return string2;
        }
        StringBuilder stringBuilder = new StringBuilder(string2);
        stringBuilder.append(' ');
        stringBuilder.append(string);
        return stringBuilder.toString();
    }

    static {
        s_unitDisplays.put(NonSI.FOOT, "'");
        s_unitDisplays.put(NonSI.INCH, "\"");
    }
}

