/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.util;

import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Locale;

public class Formatter {
    private final Locale d_locale;
    private final DecimalFormatSymbols d_symbols;
    private final ArrayList<DecimalFormat> d_decFormats;
    private final NumberFormat d_floatFormat;
    private final NumberFormat d_sciFormat;
    private static final double[] POW10 = new double[15];

    public Formatter(Locale locale) {
        this.d_locale = locale;
        this.d_symbols = DecimalFormatSymbols.getInstance(this.d_locale);
        this.d_decFormats = new ArrayList();
        this.d_floatFormat = new DecimalFormat("0.0", this.d_symbols);
        this.d_floatFormat.setRoundingMode(RoundingMode.HALF_UP);
        this.d_sciFormat = new DecimalFormat("0.0E0", this.d_symbols);
        this.d_sciFormat.setRoundingMode(RoundingMode.HALF_UP);
    }

    protected DecimalFormatSymbols getFormatSymbols() {
        return this.d_symbols;
    }

    private static int getSciExp(double d) {
        int n;
        if (d == 0.0) {
            return 0;
        }
        double d2 = d < 0.0 ? Math.log10(-d) : Math.log10(d);
        if (d2 < (double)(n = (int)d2)) {
            --n;
        }
        return n;
    }

    private static int getSciExp2(double d) {
        if (d == 0.0) {
            return 0;
        }
        if (d < 0.0) {
            d = -d;
        }
        if (d < 1000000.0 && d >= 1.0) {
            int n = 0;
            while (d >= 10.0) {
                ++n;
                d /= 10.0;
            }
            return n;
        }
        if (d < 1.0 && d >= 1.0E-6) {
            int n = 0;
            while (d < 1.0) {
                ++n;
                d *= 10.0;
            }
            return -n;
        }
        return (int)Math.floor(Math.log10(d));
    }

    private static double pow10(int n) {
        if (n >= 0 && n < POW10.length) {
            return POW10[n];
        }
        return Math.pow(10.0, n);
    }

    private static int chars(double d) {
        int n = Math.max((int)Math.log10(Math.abs(d)) + 1, 1);
        if (d < 0.0) {
            return n + 1;
        }
        return n;
    }

    public String formatFixedWidth(double d, int n) {
        return Formatter.isFloatPreferred(d, n) ? this.formatFloat(d, n) : this.formatSci(d, n);
    }

    private static boolean isFloatPreferred(double d, int n) {
        int n2 = Formatter.getSigDigitsFloat(d, n);
        int n3 = Formatter.getSigDigitsSci(d, n);
        if (d == 0.0) {
            return true;
        }
        if (1.0E-4 < d && d < 100000.0) {
            return n3 <= n2;
        }
        return n3 < n2;
    }

    private static int getSigDigitsFloat(double d, int n) {
        int n2 = n - 1;
        if (d < 0.0) {
            --n2;
        }
        int n3 = n2 - 2;
        int n4 = -n2 + 1;
        int n5 = Formatter.getSciExp(d);
        if (n5 < n4 || n3 < n5) {
            return 0;
        }
        int n6 = Math.max(n4, n5 - (n2 - 1));
        int n7 = n2 - Math.max(0, n5 + 1);
        if (Formatter.expandsWhenRounded(d, n7) && n3 < ++n5) {
            return 0;
        }
        return n5 - n6;
    }

    private static int getSigDigitsSci(double d, int n) {
        int n2 = Formatter.getSciExp(d);
        int n3 = 2 + Formatter.chars(n2);
        if (d < 0.0) {
            ++n3;
        }
        return n - n3 - 1;
    }

    private static boolean expandsWhenRounded(double d, int n) {
        double d2 = Formatter.pow10(n);
        long l = Math.round(d * d2);
        return Formatter.getSciExp(d) < Formatter.getSciExp((double)l / d2);
    }

    public String formatFloat(double d, int n) {
        int n2;
        int n3;
        if (Double.isInfinite(d) || Double.isNaN(d)) {
            return this.pad(Double.toString(d), n);
        }
        if (d == -0.0) {
            d = 0.0;
        }
        if (Formatter.expandsWhenRounded(d, n3 = Math.max(0, n - (n2 = Formatter.chars(d)) - 1))) {
            ++n2;
            --n3;
        }
        if (n3 < 1) {
            return this.pad("0" + this.getFormatSymbols().getDecimalSeparator() + '0', n);
        }
        DecimalFormat decimalFormat = this.getFloatFormat(n3);
        String string = decimalFormat.format(d);
        String string2 = this.pad(string, n);
        return this.convertTrailingZerosToLeadingSpaces(string2);
    }

    private String pad(String string, int n) {
        try {
            int n2;
            if (n <= string.length()) {
                return string.substring(0, n);
            }
            int n3 = n - string.length();
            char[] cArray = new char[n];
            for (n2 = 0; n2 < n3; ++n2) {
                cArray[n2] = 32;
            }
            for (n2 = n3; n2 < n; ++n2) {
                cArray[n2] = string.charAt(n2 - n3);
            }
            return new String(cArray);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.err.println("Error on: " + String.format("pad(%s, %d)", string, n));
            String string2 = "%" + n + "s";
            return String.format(this.d_locale, string2, string);
        }
    }

    private DecimalFormat getFloatFormat(int n) {
        DecimalFormat decimalFormat;
        if (n >= this.d_decFormats.size()) {
            for (int i = this.d_decFormats.size(); i <= n; ++i) {
                this.d_decFormats.add(null);
            }
        }
        if ((decimalFormat = this.d_decFormats.get(n)) == null) {
            char[] cArray = new char[2 + n];
            cArray[0] = 48;
            cArray[1] = 46;
            for (int i = 2; i < n + 2; ++i) {
                cArray[i] = 48;
            }
            decimalFormat = new DecimalFormat(new String(cArray), this.getFormatSymbols());
            this.d_decFormats.set(n, decimalFormat);
        }
        return decimalFormat;
    }

    private String convertTrailingZerosToLeadingSpaces(String string) {
        int n = string.indexOf(this.getFormatSymbols().getDecimalSeparator());
        if (n != -1) {
            int n2;
            int n3 = string.length();
            StringBuilder stringBuilder = new StringBuilder(n3);
            for (n2 = n3 - 1; n + 1 < n2 && string.charAt(n2) == '0'; --n2) {
                stringBuilder.append(" ");
            }
            n2 = n3 - stringBuilder.length();
            for (int i = 0; i < n2; ++i) {
                stringBuilder.append(string.charAt(i));
            }
            return stringBuilder.toString();
        }
        return string;
    }

    public String formatSci(double d, int n) {
        int n2;
        double d2;
        if (Double.isInfinite(d) || Double.isNaN(d)) {
            return this.pad(Double.toString(d), n);
        }
        if (d == -0.0) {
            d = 0.0;
        }
        int n3 = Formatter.getSciExp(d);
        int n4 = Formatter.chars(n3);
        int n5 = 2 + n4;
        if (d < 0.0) {
            ++n5;
        }
        if (Formatter.expandsWhenRounded(d2 = d / Formatter.pow10(n3), n2 = n - n5 - 1)) {
            n4 = Formatter.chars(++n3);
            n5 = 2 + n4;
            if (d < 0.0) {
                ++n5;
            }
            d2 = d / Formatter.pow10(n3);
            n2 = n - n5 - 1;
        }
        if (Double.isInfinite(d2) || Double.isNaN(d2)) {
            return this.pad(Double.toString(d2), n);
        }
        DecimalFormat decimalFormat = this.getFloatFormat(n2);
        String string = decimalFormat.format(d2);
        string = this.convertTrailingZerosToLeadingSpaces(string);
        String string2 = string + "E" + n3;
        return string2;
    }

    public String format(double d, int n) {
        if (Double.isNaN(d) || Double.isInfinite(d)) {
            return Double.toString(d);
        }
        String string = "";
        int n2 = Formatter.getSciExp2(d);
        if (-3 < n2 && n2 <= 3) {
            this.d_floatFormat.setMaximumFractionDigits(n);
            string = this.d_floatFormat.format(d);
        } else {
            this.d_sciFormat.setMaximumFractionDigits(n);
            string = this.d_sciFormat.format(d);
        }
        return this.negativeZeroCorrection(string);
    }

    public String negativeZeroCorrection(String string) {
        if (string.equals("-0.0")) {
            return "0.0";
        }
        if (string.equals("-0,0")) {
            return "0,0";
        }
        return string;
    }

    public String formatOld(double d, int n) {
        if (Double.isNaN(d) || Double.isInfinite(d)) {
            return Double.toString(d);
        }
        double d2 = Math.abs(d);
        if (d == 0.0 || d2 >= 0.001 && d2 < 10000.0) {
            int n2 = n + 1;
            if (d < 0.0) {
                ++n2;
            }
            for (int i = n2; i < 14; ++i) {
                int n3 = Formatter.getSigDigitsFloat(d, i) + 1;
                if (n3 < n) continue;
                return this.formatFloat(d, i).trim();
            }
        } else {
            return this.tryFormatSciNew(d, n);
        }
        return NumberFormat.getInstance(this.d_locale).format(d);
    }

    public String tryFormatSciNew(double d, int n) {
        int n2 = 0;
        if (d < 0.0) {
            ++n2;
        }
        ++n2;
        ++n2;
        int n3 = Formatter.getSciExp(d);
        int n4 = Formatter.chars(n3);
        return this.formatSci(d, n + (n2 += n4)).trim();
    }

    public String tryFormatSciOld(double d, int n) {
        for (int i = n; i < 14; ++i) {
            int n2 = Formatter.getSigDigitsSci(d, i) + 1;
            if (n2 < n) continue;
            return this.formatSci(d, i).trim();
        }
        return null;
    }

    public static void main(String[] stringArray) {
        Formatter formatter = new Formatter(Locale.ENGLISH);
        System.out.println(formatter.format(Double.NaN, 5));
        System.out.println(formatter.format(Double.NEGATIVE_INFINITY, 5));
        System.out.println(formatter.format(Double.POSITIVE_INFINITY, 5));
        System.out.println(formatter.format(-1.7976931348623157E308, 5));
        System.out.println(formatter.format(Double.MAX_VALUE, 5));
        System.out.println(formatter.format(-4.9E-324, 5));
        System.out.println(formatter.format(Double.MIN_VALUE, 5));
        System.out.println(formatter.format(1.0E-4, 5));
        System.out.println(formatter.format(-1.0E-4, 5));
        System.out.println(formatter.format(0.01, 5));
        System.out.println(formatter.format(-0.01, 5));
        System.out.println(formatter.format(0.01, 1));
        System.out.println(formatter.format(-0.01, 1));
        System.out.println();
        formatter = new Formatter(Locale.GERMANY);
        System.out.println(formatter.format(Double.NaN, 5));
        System.out.println(formatter.format(Double.NEGATIVE_INFINITY, 5));
        System.out.println(formatter.format(Double.POSITIVE_INFINITY, 5));
        System.out.println(formatter.format(-1.7976931348623157E308, 5));
        System.out.println(formatter.format(Double.MAX_VALUE, 5));
        System.out.println(formatter.format(-4.9E-324, 5));
        System.out.println(formatter.format(Double.MIN_VALUE, 5));
        System.out.println(formatter.format(1.0E-4, 5));
        System.out.println(formatter.format(-1.0E-4, 5));
        System.out.println(formatter.format(0.01, 5));
        System.out.println(formatter.format(-0.01, 5));
        System.out.println(formatter.format(0.01, 1));
        System.out.println(formatter.format(-0.01, 1));
    }

    static {
        for (int i = 0; i < POW10.length; ++i) {
            Formatter.POW10[i] = Math.pow(10.0, i);
        }
    }
}

