/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.util;

import java.util.AbstractList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class FlattenedList<ElemT>
extends AbstractList<ElemT> {
    private final List<? extends List<ElemT>> d_lists;
    private int[] d_offsets;
    private Integer d_count;

    public FlattenedList(List<? extends List<ElemT>> list) {
        this.d_lists = list;
    }

    private void cacheOffsets() {
        if (this.d_offsets != null) {
            return;
        }
        this.d_offsets = new int[this.d_lists.size()];
        int n = 0;
        for (int i = 0; i < this.d_lists.size(); ++i) {
            this.d_offsets[i] = n;
            n += this.d_lists.get(i).size();
        }
        this.d_count = n;
    }

    @Override
    public synchronized ElemT get(int n) {
        this.cacheOffsets();
        int n2 = Arrays.binarySearch(this.d_offsets, n);
        if (n2 < 0) {
            n2 -= 2;
        }
        assert (n2 >= 0);
        int n3 = this.d_offsets[n2];
        return this.d_lists.get(n2).get(n - n3);
    }

    @Override
    public synchronized int size() {
        this.cacheOffsets();
        return this.d_count;
    }

    @Override
    public Iterator<ElemT> iterator() {
        return new It();
    }

    private class It
    implements Iterator<ElemT> {
        private Iterator<? extends List<ElemT>> d_suppliersIt;
        private Iterator<ElemT> d_supplierIt = null;

        private It() {
            this.d_suppliersIt = FlattenedList.this.d_lists.iterator();
            this.prefetchNext();
            if (this.d_supplierIt == null) {
                this.d_supplierIt = Collections.emptyIterator();
            }
        }

        @Override
        public boolean hasNext() {
            return this.d_supplierIt.hasNext();
        }

        @Override
        public ElemT next() {
            Object ElemT = this.d_supplierIt.next();
            if (!this.d_supplierIt.hasNext()) {
                this.prefetchNext();
            }
            return ElemT;
        }

        private void prefetchNext() {
            while (this.d_suppliersIt.hasNext()) {
                List list = this.d_suppliersIt.next();
                this.d_supplierIt = list.iterator();
                if (!this.d_supplierIt.hasNext()) continue;
                break;
            }
        }
    }
}

