/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.util;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;

public class FlatMappedIterator<T, R>
implements Iterator<R> {
    private final Iterator<T> d_base;
    private final Function<? super T, ? extends Iterable<? extends R>> d_mapper;
    private Iterator<? extends R> d_flatIterator;

    public FlatMappedIterator(Iterator<T> iterator, Function<? super T, ? extends Iterable<? extends R>> function) {
        this.d_base = iterator;
        this.d_mapper = function;
        this.d_flatIterator = null;
    }

    private void initIterator() {
        if (this.d_flatIterator == null) {
            this.d_flatIterator = this.findNextIterator();
        }
    }

    @Override
    public boolean hasNext() {
        this.initIterator();
        return this.d_flatIterator.hasNext();
    }

    @Override
    public R next() {
        this.initIterator();
        R r = this.d_flatIterator.next();
        if (!this.d_flatIterator.hasNext()) {
            this.d_flatIterator = this.findNextIterator();
        }
        return r;
    }

    private Iterator<? extends R> findNextIterator() {
        while (this.d_base.hasNext()) {
            Iterator<R> iterator = this.d_mapper.apply(this.d_base.next()).iterator();
            if (!iterator.hasNext()) continue;
            return iterator;
        }
        return Collections.emptyIterator();
    }
}

