/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.util;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;
import thunderheadeng.util.APredicate;
import thunderheadeng.util.Predicates;
import thunderheadeng.util.Sets;
import thunderheadeng.util.theUtil;

public class Filters
extends Predicates {
    public static <T> Predicate<T> rejectAll() {
        return Filters.alwaysFalse();
    }

    public static <T> Predicate<T> rejectAll(Class<T> clazz) {
        return Filters.alwaysFalse();
    }

    public static <T> Predicate<T> acceptAll() {
        return Filters.alwaysTrue();
    }

    public static <T> Predicate<T> acceptAll(Class<T> clazz) {
        return Filters.alwaysTrue();
    }

    public static <T> Predicate<T> reject(T t) {
        return new ExcludeOne(t);
    }

    public static <T> Predicate<T> reject(T ... TArray) {
        if (TArray.length == 1) {
            return Filters.reject(TArray[0]);
        }
        Collection<T> collection = TArray.length < 5 ? Arrays.asList(TArray) : Sets.fromArrayHS(TArray);
        return Filters.reject(collection);
    }

    public static <T> Predicate<T> reject(Collection<T> collection) {
        if (collection.isEmpty()) {
            return Filters.acceptAll();
        }
        if (collection.size() == 1) {
            return new ExcludeOne(collection.iterator().next());
        }
        return new ExcludeMultiple(collection);
    }

    public static <T> Predicate<T> reject(Collection<?> collection, Class<T> clazz) {
        if (collection.isEmpty()) {
            return Filters.acceptAll();
        }
        if (collection.size() == 1) {
            return new ExcludeOne(collection.iterator().next());
        }
        return new ExcludeMultiple(collection);
    }

    public static <T> Predicate<T> accept(T t) {
        return new AcceptOnlyOne(t);
    }

    public static <T> Predicate<T> accept(T ... TArray) {
        Collection<T> collection = TArray.length < 5 ? Arrays.asList(TArray) : Sets.fromArrayHS(TArray);
        return Filters.accept(collection);
    }

    public static <T> Predicate<T> accept(Collection<T> collection) {
        if (collection.isEmpty()) {
            return Filters.rejectAll();
        }
        if (collection.size() == 1) {
            return new AcceptOnlyOne(collection.iterator().next());
        }
        return new AcceptOnlyMultiple(collection);
    }

    public static <T> Predicate<T> accept(Collection<?> collection, Class<T> clazz) {
        if (collection.isEmpty()) {
            return Filters.rejectAll();
        }
        if (collection.size() == 1) {
            return new AcceptOnlyOne(collection.iterator().next());
        }
        return new AcceptOnlyMultiple(collection);
    }

    private static int hashAsSet(Collection<?> collection) {
        int n = 0;
        for (Object obj : collection) {
            n += theUtil.hashCode(obj);
        }
        return n;
    }

    private static boolean equalAsSets(Collection<?> collection, Collection<?> collection2) {
        if (collection instanceof Set && collection2 instanceof Set) {
            return collection.equals(collection2);
        }
        return collection.size() == collection2.size() && collection.containsAll(collection2);
    }

    private static <T> Predicate<T> or(AcceptOnlyMultiple<?> acceptOnlyMultiple, AcceptOnlyOne<?> acceptOnlyOne) {
        if (acceptOnlyMultiple.toInclude.contains(acceptOnlyOne.toInclude)) {
            return acceptOnlyMultiple;
        }
        HashSet hashSet = new HashSet(acceptOnlyMultiple.toInclude);
        hashSet.add(acceptOnlyOne.toInclude);
        return Filters.accept(hashSet);
    }

    private static <T> Predicate<T> or(ExcludeMultiple<?> excludeMultiple, ExcludeOne<?> excludeOne) {
        if (excludeMultiple.toExclude.contains(excludeOne.toExclude)) {
            return excludeOne;
        }
        return Filters.alwaysTrue();
    }

    private static <T> Predicate<T> or(AcceptOnlyMultiple<?> acceptOnlyMultiple, ExcludeOne<?> excludeOne) {
        if (!acceptOnlyMultiple.toInclude.contains(excludeOne.toExclude)) {
            return excludeOne;
        }
        return Predicates.alwaysTrue();
    }

    private static <T> Predicate<T> or(AcceptOnlyMultiple<?> acceptOnlyMultiple, ExcludeMultiple<?> excludeMultiple) {
        HashSet hashSet = new HashSet(excludeMultiple.toExclude);
        hashSet.removeAll(acceptOnlyMultiple.toInclude);
        return Filters.reject(hashSet);
    }

    private static <T> Predicate<T> or(AcceptOnlyOne<?> acceptOnlyOne, ExcludeOne<?> excludeOne) {
        if (!theUtil.equal(acceptOnlyOne.toInclude, excludeOne.toExclude)) {
            return excludeOne;
        }
        return Predicates.alwaysTrue();
    }

    private static <T> Predicate<T> or(AcceptOnlyOne<?> acceptOnlyOne, ExcludeMultiple<?> excludeMultiple) {
        if (!excludeMultiple.toExclude.contains(acceptOnlyOne.toInclude)) {
            return excludeMultiple;
        }
        HashSet hashSet = new HashSet(excludeMultiple.toExclude);
        hashSet.remove(acceptOnlyOne.toInclude);
        return Filters.reject(hashSet);
    }

    private static <T> Predicate<T> and(ExcludeMultiple<?> excludeMultiple, ExcludeOne<?> excludeOne) {
        if (excludeMultiple.toExclude.contains(excludeMultiple.toExclude)) {
            return excludeMultiple;
        }
        HashSet hashSet = new HashSet(excludeMultiple.toExclude);
        hashSet.add(excludeOne.toExclude);
        return Filters.reject(hashSet);
    }

    private static <T> Predicate<T> and(AcceptOnlyMultiple<?> acceptOnlyMultiple, AcceptOnlyOne<?> acceptOnlyOne) {
        if (acceptOnlyMultiple.toInclude.contains(acceptOnlyOne.toInclude)) {
            return acceptOnlyOne;
        }
        return Predicates.alwaysFalse();
    }

    private static <T> Predicate<T> and(AcceptOnlyMultiple<?> acceptOnlyMultiple, ExcludeOne<?> excludeOne) {
        if (!acceptOnlyMultiple.toInclude.contains(excludeOne.toExclude)) {
            return acceptOnlyMultiple;
        }
        HashSet hashSet = new HashSet(acceptOnlyMultiple.toInclude);
        hashSet.remove(excludeOne.toExclude);
        return Filters.accept(hashSet);
    }

    private static <T> Predicate<T> and(AcceptOnlyMultiple<?> acceptOnlyMultiple, ExcludeMultiple<?> excludeMultiple) {
        HashSet hashSet = new HashSet(acceptOnlyMultiple.toInclude);
        hashSet.removeAll(excludeMultiple.toExclude);
        return Filters.accept(hashSet);
    }

    private static <T> Predicate<T> and(AcceptOnlyOne<?> acceptOnlyOne, ExcludeOne<?> excludeOne) {
        if (!theUtil.equal(acceptOnlyOne.toInclude, excludeOne.toExclude)) {
            return acceptOnlyOne;
        }
        return Filters.rejectAll();
    }

    private static <T> Predicate<T> and(AcceptOnlyOne<?> acceptOnlyOne, ExcludeMultiple<?> excludeMultiple) {
        if (!excludeMultiple.toExclude.contains(acceptOnlyOne.toInclude)) {
            return acceptOnlyOne;
        }
        return Filters.rejectAll();
    }

    private static class AcceptOnlyMultiple<T>
    extends APredicate<T>
    implements Serializable {
        static final long serialVersionUID = 1L;
        public final Collection<?> toInclude;

        public AcceptOnlyMultiple(Collection<?> collection) {
            this.toInclude = collection;
        }

        @Override
        public boolean shouldFilter(T t) {
            return !this.toInclude.contains(t);
        }

        @Override
        public boolean test(T t) {
            return this.toInclude.contains(t);
        }

        public boolean equals(Object object) {
            return object instanceof AcceptOnlyMultiple && Filters.equalAsSets(this.toInclude, ((AcceptOnlyMultiple)object).toInclude);
        }

        public int hashCode() {
            return 0x723498FA ^ Filters.hashAsSet(this.toInclude);
        }

        @Override
        public Predicate<T> and(Predicate<? super T> predicate) {
            if (predicate instanceof AcceptOnlyMultiple) {
                HashSet hashSet = new HashSet(this.toInclude);
                hashSet.retainAll(((AcceptOnlyMultiple)predicate).toInclude);
                return Filters.accept(hashSet);
            }
            if (predicate instanceof AcceptOnlyOne) {
                return Filters.and(this, (AcceptOnlyOne)predicate);
            }
            if (predicate instanceof ExcludeOne) {
                return Filters.and(this, (ExcludeOne)predicate);
            }
            if (predicate instanceof ExcludeMultiple) {
                return Filters.and(this, (ExcludeMultiple)predicate);
            }
            return super.and(predicate);
        }

        @Override
        public Predicate<T> or(Predicate<? super T> predicate) {
            if (predicate instanceof AcceptOnlyMultiple) {
                HashSet hashSet = new HashSet(this.toInclude);
                hashSet.addAll(((AcceptOnlyMultiple)predicate).toInclude);
                return Filters.accept(hashSet);
            }
            if (predicate instanceof AcceptOnlyOne) {
                return Filters.or(this, (AcceptOnlyOne)predicate);
            }
            if (predicate instanceof ExcludeOne) {
                return Filters.or(this, (ExcludeOne)predicate);
            }
            if (predicate instanceof ExcludeMultiple) {
                return Filters.or(this, (ExcludeMultiple)predicate);
            }
            return super.or(predicate);
        }

        @Override
        public Predicate<T> negate() {
            return new ExcludeMultiple(this.toInclude);
        }
    }

    private static class AcceptOnlyOne<T>
    extends APredicate<T>
    implements Serializable {
        static final long serialVersionUID = 1L;
        public final Object toInclude;

        public AcceptOnlyOne(Object object) {
            this.toInclude = object;
        }

        @Override
        public boolean shouldFilter(T t) {
            return !theUtil.equal(t, this.toInclude);
        }

        @Override
        public boolean test(T t) {
            return theUtil.equal(t, this.toInclude);
        }

        public boolean equals(Object object) {
            return object instanceof AcceptOnlyOne && theUtil.equal(this.toInclude, ((AcceptOnlyOne)object).toInclude);
        }

        public int hashCode() {
            return 0xF23FA3 ^ theUtil.hashCode(this.toInclude);
        }

        @Override
        public Predicate<T> and(Predicate<? super T> predicate) {
            if (predicate instanceof AcceptOnlyMultiple) {
                return Filters.and((AcceptOnlyMultiple)predicate, this);
            }
            if (predicate instanceof AcceptOnlyOne) {
                AcceptOnlyOne acceptOnlyOne = (AcceptOnlyOne)predicate;
                if (theUtil.equal(this.toInclude, acceptOnlyOne.toInclude)) {
                    return this;
                }
                return Predicates.alwaysFalse();
            }
            if (predicate instanceof ExcludeOne) {
                return Filters.and(this, (ExcludeOne)predicate);
            }
            if (predicate instanceof ExcludeMultiple) {
                return Filters.and(this, (ExcludeMultiple)predicate);
            }
            return super.and(predicate);
        }

        @Override
        public Predicate<T> or(Predicate<? super T> predicate) {
            if (predicate instanceof AcceptOnlyMultiple) {
                return Filters.or((AcceptOnlyMultiple)predicate, this);
            }
            if (predicate instanceof AcceptOnlyOne) {
                AcceptOnlyOne acceptOnlyOne = (AcceptOnlyOne)predicate;
                if (theUtil.equal(this.toInclude, acceptOnlyOne.toInclude)) {
                    return this;
                }
                return Filters.accept(this.toInclude, acceptOnlyOne.toInclude);
            }
            if (predicate instanceof ExcludeOne) {
                return Filters.or(this, (ExcludeOne)predicate);
            }
            if (predicate instanceof ExcludeMultiple) {
                return Filters.or(this, (ExcludeMultiple)predicate);
            }
            return super.or(predicate);
        }

        @Override
        public Predicate<T> negate() {
            return new ExcludeOne(this.toInclude);
        }
    }

    private static class ExcludeMultiple<T>
    extends APredicate<T>
    implements Serializable {
        static final long serialVersionUID = 1L;
        public final Collection<?> toExclude;

        public ExcludeMultiple(Collection<?> collection) {
            this.toExclude = collection;
        }

        @Override
        public boolean shouldFilter(T t) {
            return this.toExclude.contains(t);
        }

        @Override
        public boolean test(T t) {
            return !this.toExclude.contains(t);
        }

        public boolean equals(Object object) {
            return object instanceof ExcludeMultiple && Filters.equalAsSets(this.toExclude, ((ExcludeMultiple)object).toExclude);
        }

        public int hashCode() {
            return 0x72437832 ^ Filters.hashAsSet(this.toExclude);
        }

        @Override
        public Predicate<T> and(Predicate<? super T> predicate) {
            if (predicate instanceof AcceptOnlyMultiple) {
                return Filters.and((AcceptOnlyMultiple)predicate, this);
            }
            if (predicate instanceof AcceptOnlyOne) {
                return Filters.and((AcceptOnlyOne)predicate, this);
            }
            if (predicate instanceof ExcludeMultiple) {
                ExcludeMultiple excludeMultiple = (ExcludeMultiple)predicate;
                HashSet hashSet = new HashSet(this.toExclude);
                hashSet.addAll(excludeMultiple.toExclude);
                return Filters.reject(hashSet);
            }
            if (predicate instanceof ExcludeOne) {
                return Filters.and(this, (ExcludeOne)predicate);
            }
            return super.and(predicate);
        }

        @Override
        public Predicate<T> or(Predicate<? super T> predicate) {
            if (predicate instanceof AcceptOnlyMultiple) {
                return Filters.or((AcceptOnlyMultiple)predicate, this);
            }
            if (predicate instanceof AcceptOnlyOne) {
                return Filters.or((AcceptOnlyOne)predicate, this);
            }
            if (predicate instanceof ExcludeMultiple) {
                ExcludeMultiple excludeMultiple = (ExcludeMultiple)predicate;
                HashSet hashSet = new HashSet(this.toExclude);
                hashSet.retainAll(excludeMultiple.toExclude);
                return Filters.reject(hashSet);
            }
            if (predicate instanceof ExcludeOne) {
                return Filters.or(this, (ExcludeOne)predicate);
            }
            return super.or(predicate);
        }

        @Override
        public Predicate<T> negate() {
            return new AcceptOnlyMultiple(this.toExclude);
        }
    }

    private static class ExcludeOne<T>
    extends APredicate<T>
    implements Serializable {
        static final long serialVersionUID = 1L;
        public final Object toExclude;

        public ExcludeOne(Object object) {
            this.toExclude = object;
        }

        @Override
        public boolean shouldFilter(T t) {
            return theUtil.equal(this.toExclude, t);
        }

        @Override
        public boolean test(T t) {
            return !theUtil.equal(this.toExclude, t);
        }

        public boolean equals(Object object) {
            return object instanceof ExcludeOne && theUtil.equal(this.toExclude, ((ExcludeOne)object).toExclude);
        }

        public int hashCode() {
            return 0x1672349F ^ theUtil.hashCode(this.toExclude);
        }

        @Override
        public Predicate<T> and(Predicate<? super T> predicate) {
            if (predicate instanceof AcceptOnlyMultiple) {
                return Filters.and((AcceptOnlyMultiple)predicate, this);
            }
            if (predicate instanceof AcceptOnlyOne) {
                return Filters.and((AcceptOnlyOne)predicate, this);
            }
            if (predicate instanceof ExcludeMultiple) {
                return Filters.and((ExcludeMultiple)predicate, this);
            }
            if (predicate instanceof ExcludeOne) {
                ExcludeOne excludeOne = (ExcludeOne)predicate;
                if (theUtil.equal(this.toExclude, excludeOne.toExclude)) {
                    return this;
                }
                return Filters.reject(this.toExclude, excludeOne.toExclude);
            }
            return super.and(predicate);
        }

        @Override
        public Predicate<T> or(Predicate<? super T> predicate) {
            if (predicate instanceof AcceptOnlyMultiple) {
                return Filters.or((AcceptOnlyMultiple)predicate, this);
            }
            if (predicate instanceof AcceptOnlyOne) {
                return Filters.or((AcceptOnlyOne)predicate, this);
            }
            if (predicate instanceof ExcludeMultiple) {
                return Filters.or((ExcludeMultiple)predicate, this);
            }
            if (predicate instanceof ExcludeOne) {
                ExcludeOne excludeOne = (ExcludeOne)predicate;
                if (theUtil.equal(this.toExclude, excludeOne.toExclude)) {
                    return this;
                }
                return Filters.alwaysTrue();
            }
            return super.or(predicate);
        }

        @Override
        public Predicate<T> negate() {
            return new AcceptOnlyOne(this.toExclude);
        }
    }
}

