/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.util;

import java.util.Collection;
import java.util.function.Predicate;
import thunderheadeng.util.AFilteredCollection;
import thunderheadeng.util.FilteredIterator;
import thunderheadeng.util.Filters;

public class FilteredCollection<T>
extends AFilteredCollection<T, Object> {
    private final Class<T> d_type;
    private final Predicate<? super T> d_filter;

    public FilteredCollection(Collection<?> collection, Class<T> clazz) {
        this(collection, clazz, Filters.acceptAll());
    }

    public FilteredCollection(Collection<?> collection, Class<T> clazz, Predicate<? super T> predicate) {
        super(collection);
        this.d_filter = predicate;
        this.d_type = clazz;
    }

    public Class<T> getType() {
        return this.d_type;
    }

    public Predicate<? super T> getFilter() {
        return this.d_filter;
    }

    @Override
    public FilteredIterator<T> iterator() {
        return new FilteredIterator<T>(this.getUnfiltered().iterator(), this.d_type, this.d_filter);
    }

    @Override
    protected boolean accept(Object object) {
        return this.d_type.isInstance(object) && this.d_filter.test(this.d_type.cast(object));
    }
}

