/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import thunderheadeng.util.Events;
import thunderheadeng.util.Filters;

public class FilterMgr {
    private final Events d_events;
    private final Map<Class, Predicate> d_filters = new HashMap<Class, Predicate>();
    private final Map<Class, Predicate> d_cachedFilters = new HashMap<Class, Predicate>();

    public FilterMgr(Events events) {
        this.d_events = events;
    }

    protected void changed(Class clazz) {
        this.d_cachedFilters.clear();
        if (this.d_events != null) {
            this.d_events.changed(this, clazz);
        }
    }

    public <T> void registerFilter(Class<T> clazz, Predicate<? extends T> predicate) {
        Predicate<? extends T> predicate2;
        assert (predicate != null) : "Filter must not be null. To remove a filter, use the method, removeFilter.";
        if (Filters.alwaysFalse(predicate) && !predicate.equals(predicate2 = this.d_filters.put(clazz, predicate))) {
            this.changed(clazz);
            return;
        }
        predicate2 = this.d_filters.get(clazz);
        if (predicate2 instanceof CompositeFilter) {
            if (((CompositeFilter)predicate2).add(predicate)) {
                this.changed(clazz);
            }
        } else if (predicate2 != null && !predicate.equals(predicate2)) {
            CompositeFilter compositeFilter = new CompositeFilter(predicate2, predicate);
            this.d_filters.put(clazz, compositeFilter);
            this.changed(clazz);
        } else {
            this.d_filters.put(clazz, predicate);
            this.changed(clazz);
        }
    }

    public <T> void filterAllOfType(Class<T> clazz) {
        this.registerFilter(clazz, Filters.rejectAll(clazz));
    }

    public <T> void removeFilter(Class<T> clazz, Predicate<T> predicate) {
        Predicate predicate2 = this.d_filters.get(clazz);
        if (predicate2 instanceof CompositeFilter) {
            CompositeFilter compositeFilter = (CompositeFilter)predicate2;
            if (compositeFilter.remove(predicate)) {
                if (compositeFilter.d_filters.size() == 1) {
                    this.d_filters.put(clazz, (Predicate)compositeFilter.d_filters.get(0));
                }
                this.changed(clazz);
            }
        } else if (predicate.equals(predicate2)) {
            this.d_filters.remove(clazz);
            this.changed(clazz);
        }
    }

    public boolean isFilteringAllOf(Class clazz) {
        Predicate predicate = this.getFilter(clazz);
        return Filters.alwaysFalse(predicate);
    }

    public boolean filter(Object object) {
        Predicate predicate = this.getFilter(object.getClass());
        if (predicate == null) {
            return false;
        }
        return !predicate.test(object);
    }

    private Predicate getFilter(Class clazz) {
        if (this.d_cachedFilters.containsKey(clazz)) {
            return this.d_cachedFilters.get(clazz);
        }
        Predicate predicate = this.calculateFilter(clazz);
        this.d_cachedFilters.put(clazz, predicate);
        return predicate;
    }

    private Predicate calculateFilter(Class clazz) {
        Predicate predicate = this.d_filters.get(clazz);
        if (predicate != null) {
            return predicate;
        }
        Class clazz2 = clazz.getSuperclass();
        if (clazz2 != null && (predicate = this.calculateFilter(clazz2)) != null) {
            return predicate;
        }
        for (Class<?> clazz3 : clazz.getInterfaces()) {
            predicate = this.calculateFilter(clazz3);
            if (predicate == null) continue;
            return predicate;
        }
        return null;
    }

    public void reset() {
        this.d_filters.clear();
        if (this.d_events != null) {
            this.d_events.changed(this, new Object[0]);
        }
    }

    private static class CompositeFilter<T>
    implements Predicate<T> {
        private final List<Predicate<T>> d_filters;

        public CompositeFilter(Predicate<T> ... predicateArray) {
            this.d_filters = new ArrayList<Predicate<T>>(Arrays.asList(predicateArray));
        }

        public boolean add(Predicate<T> predicate) {
            int n = this.d_filters.indexOf(predicate);
            if (n < 0) {
                this.d_filters.add(predicate);
                return true;
            }
            return false;
        }

        public boolean remove(Predicate<T> predicate) {
            return this.d_filters.remove(predicate);
        }

        @Override
        public boolean test(T t) {
            for (Predicate<T> predicate : this.d_filters) {
                if (predicate.test(t)) continue;
                return false;
            }
            return true;
        }
    }
}

