/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.util;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import thunderheadeng.util.AEventRec;
import thunderheadeng.util.EmptyEventRec;
import thunderheadeng.util.Events;
import thunderheadeng.util.Filters;
import thunderheadeng.util.IEventRecord;
import thunderheadeng.util.LinkedIdentityHashSet;
import thunderheadeng.util.Predicates;
import thunderheadeng.util.theUtil;

public class EventChannel<ObjT>
extends AEventRec<ObjT> {
    public static final Object EVT_GENERAL = Events.EVT_GENERAL;
    private final Set<ObjT> d_adds;
    private final Set<ObjT> d_removes;
    private final Map<Object, Set<ObjT>> d_changeMap;
    private final Class<ObjT> d_type;
    private final boolean d_identityObjHash;
    private final Predicate<? super ObjT> d_filter;

    public EventChannel(Class<ObjT> clazz, boolean bl) {
        this.d_type = clazz;
        this.d_identityObjHash = bl;
        this.d_adds = this.newObjSet();
        this.d_removes = this.newObjSet();
        this.d_changeMap = new LinkedHashMap<Object, Set<ObjT>>();
        this.d_filter = Predicates.alwaysTrue();
    }

    protected EventChannel(Class<ObjT> clazz, Set<ObjT> set, Set<ObjT> set2, Map<Object, Set<ObjT>> map, boolean bl, Predicate<? super ObjT> predicate) {
        this.d_type = clazz;
        this.d_adds = set;
        this.d_removes = set2;
        this.d_changeMap = map;
        this.d_identityObjHash = bl;
        this.d_filter = predicate;
    }

    @Override
    public IEventRecord<ObjT> filter(Predicate<? super ObjT> predicate) {
        if (Predicates.alwaysTrue(predicate)) {
            return this;
        }
        if (Predicates.alwaysFalse(predicate)) {
            return EmptyEventRec.INSTANCE;
        }
        return new EventChannel<ObjT>(this.d_type, this.d_adds, this.d_removes, this.d_changeMap, this.d_identityObjHash, predicate);
    }

    public Class<ObjT> getObjectType() {
        return this.d_type;
    }

    public Predicate<? super ObjT> getFilter() {
        return this.d_filter;
    }

    public boolean handlesSubType(Class clazz) {
        return clazz.isAssignableFrom(this.d_type);
    }

    protected Set<ObjT> newObjSet() {
        return this.d_identityObjHash ? new LinkedIdentityHashSet() : new LinkedHashSet();
    }

    public boolean added(ObjT ObjT) {
        if (!this.d_removes.remove(ObjT)) {
            this.d_adds.add(ObjT);
            return true;
        }
        return this.changed(ObjT, new Object[0]);
    }

    public boolean added(ObjT ... ObjTArray) {
        boolean bl = false;
        for (ObjT ObjT : ObjTArray) {
            if (!this.added(ObjT)) continue;
            bl = true;
        }
        return bl;
    }

    public boolean added(Collection<? extends ObjT> collection) {
        boolean bl = false;
        for (ObjT ObjT : collection) {
            if (!this.added(ObjT)) continue;
            bl = true;
        }
        return bl;
    }

    private void removeChangesTo(ObjT ObjT) {
        Iterator<Map.Entry<Object, Set<ObjT>>> iterator = this.d_changeMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Object, Set<ObjT>> entry = iterator.next();
            Set<ObjT> set = entry.getValue();
            if (!set.remove(ObjT) || !set.isEmpty()) continue;
            iterator.remove();
        }
    }

    private void addChangeTo(ObjT ObjT, Object object) {
        Set<ObjT> set = this.d_changeMap.get(object);
        if (set == null) {
            set = this.newObjSet();
            this.d_changeMap.put(object, set);
        }
        set.add(ObjT);
    }

    public boolean removed(ObjT ObjT) {
        if (!this.d_adds.remove(ObjT)) {
            this.removeChangesTo(ObjT);
            this.d_removes.add(ObjT);
            return true;
        }
        return false;
    }

    public boolean removed(ObjT ... ObjTArray) {
        boolean bl = false;
        for (ObjT ObjT : ObjTArray) {
            bl |= this.removed(ObjT);
        }
        return bl;
    }

    public boolean removed(Collection<? extends ObjT> collection) {
        boolean bl = false;
        for (ObjT ObjT : collection) {
            bl |= this.removed(ObjT);
        }
        return bl;
    }

    public boolean changed(ObjT ObjT, Object ... objectArray) {
        if (!this.d_adds.contains(ObjT) && !this.d_removes.contains(ObjT)) {
            if (objectArray.length == 0) {
                this.addChangeTo(ObjT, EVT_GENERAL);
            } else {
                for (Object object : objectArray) {
                    this.addChangeTo(ObjT, object);
                }
            }
            return true;
        }
        return false;
    }

    public boolean changed(Collection<? extends ObjT> collection, Object ... objectArray) {
        boolean bl = false;
        for (ObjT ObjT : collection) {
            bl |= this.changed(ObjT, objectArray);
        }
        return bl;
    }

    @Override
    private Set<ObjT> filter(Set<ObjT> set) {
        return theUtil.filter(set, this.d_filter);
    }

    @Override
    public Set<ObjT> getAddedObjs() {
        return this.filter(Collections.unmodifiableSet(this.d_adds));
    }

    @Override
    public Set<ObjT> getRemovedObjs() {
        return this.filter(Collections.unmodifiableSet(this.d_removes));
    }

    @Override
    public Set<Object> getChanges() {
        if (this.d_changeMap.isEmpty() || Predicates.alwaysTrue(this.d_filter)) {
            return Collections.unmodifiableSet(this.d_changeMap.keySet());
        }
        return theUtil.map(theUtil.filter(this.d_changeMap.entrySet(), entry -> !this.filter((Set)entry.getValue()).isEmpty()), entry -> entry.getKey());
    }

    @Override
    public void getChanges(Object object, Collection<Object> collection) {
        if (this.d_type.isInstance(object) && !this.d_filter.test(object)) {
            return;
        }
        for (Map.Entry<Object, Set<ObjT>> entry : this.d_changeMap.entrySet()) {
            if (!entry.getValue().contains(object)) continue;
            collection.add(entry.getKey());
        }
    }

    @Override
    public Set<ObjT> getChangedObjs(Predicate<Object> predicate) {
        if (this.d_changeMap.isEmpty() || predicate == Filters.rejectAll()) {
            return Collections.EMPTY_SET;
        }
        int n = 0;
        Set<ObjT> set = Collections.EMPTY_SET;
        for (Map.Entry<Object, Set<ObjT>> entry : this.d_changeMap.entrySet()) {
            if (!predicate.test(entry.getKey())) continue;
            if (n == 0) {
                set = this.filter(entry.getValue());
            } else {
                if (n == 1) {
                    Set<ObjT> set2 = this.newObjSet();
                    set2.addAll(this.filter(set));
                    set = set2;
                }
                set.addAll(this.filter(entry.getValue()));
            }
            ++n;
        }
        return set;
    }

    @Override
    public Set<ObjT> getChangedObjs(Object ... objectArray) {
        if (this.d_changeMap.isEmpty()) {
            return Collections.EMPTY_SET;
        }
        if (objectArray.length == 0) {
            if (this.d_changeMap.size() == 1) {
                return this.filter(this.d_changeMap.values().iterator().next());
            }
            Set<ObjT> set = this.newObjSet();
            for (Set<ObjT> set2 : this.d_changeMap.values()) {
                set.addAll(this.filter(set2));
            }
            return set;
        }
        if (objectArray.length == 1) {
            Set<ObjT> set = this.d_changeMap.get(objectArray[0]);
            if (set == null) {
                return Collections.EMPTY_SET;
            }
            return this.filter(set);
        }
        Set<ObjT> set = this.newObjSet();
        for (Object object : objectArray) {
            Set<ObjT> set3 = this.d_changeMap.get(object);
            if (set3 == null) continue;
            set.addAll(this.filter(set3));
        }
        return set;
    }

    @Override
    public boolean isChanged(Object object) {
        if (this.d_type.isInstance(object) && !this.d_filter.test(object)) {
            return false;
        }
        for (Set<ObjT> set : this.d_changeMap.values()) {
            if (!set.contains(object)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isChanged(Object object, Object object2) {
        if (this.d_type.isInstance(object) && !this.d_filter.test(object)) {
            return false;
        }
        return this.d_changeMap.getOrDefault(object2, Collections.emptySet()).contains(object);
    }

    @Override
    public boolean containsChange(Object object) {
        Set<ObjT> set = this.d_changeMap.get(object);
        if (set == null) {
            return false;
        }
        return !this.filter(set).isEmpty();
    }

    protected void eventDispatched() {
        this.d_adds.clear();
        this.d_removes.clear();
        this.d_changeMap.clear();
    }

    public String toString() {
        return "EventChannel of " + this.d_type;
    }
}

