/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.util;

import java.io.Serializable;
import thunderheadeng.util.AbstractValueRange;
import thunderheadeng.util.Global;

public final class DoubleVR
extends AbstractValueRange<Double>
implements Serializable {
    static final long serialVersionUID = 1L;
    public static final DoubleVR UNBOUNDED = new DoubleVR(0.0, 0.0, false, false, false, false);

    private DoubleVR(double d, double d2, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        super(d, d2, bl, bl2, bl3, bl4);
    }

    public static DoubleVR unbounded() {
        return UNBOUNDED;
    }

    public static DoubleVR above(double d, boolean bl) {
        return new DoubleVR(d, 0.0, true, false, bl, false);
    }

    public static DoubleVR below(double d, boolean bl) {
        return new DoubleVR(0.0, d, false, true, false, bl);
    }

    public static DoubleVR between(double d, double d2, boolean bl, boolean bl2) {
        return new DoubleVR(d, d2, true, true, bl, bl2);
    }

    @Override
    public String format(Object object) {
        return Global.format((Double)object);
    }

    @Override
    protected Double clampMaxUnincl(Double d) {
        assert (this.getMaxValue() != null);
        if (this.checksMin() && this.checksMax() && ((Double)this.getMinValue()).equals(this.getMaxValue())) {
            return null;
        }
        if (d != null && d >= (Double)this.getMaxValue()) {
            return (Double)this.getMaxValue() - this.getClampOffset();
        }
        return d;
    }

    @Override
    protected Double clampMinUnincl(Double d) {
        assert (this.getMinValue() != null);
        if (this.checksMin() && this.checksMax() && ((Double)this.getMinValue()).equals(this.getMaxValue())) {
            return null;
        }
        if (d != null && d <= (Double)this.getMinValue()) {
            return (Double)this.getMinValue() + this.getClampOffset();
        }
        return d;
    }

    private double getClampOffset() {
        if (this.checksMin() && this.checksMax()) {
            double d = (Double)this.getMaxValue() - (Double)this.getMinValue();
            return d * 1.0E-6;
        }
        return 0.01;
    }
}

