/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.util;

import java.io.Serializable;
import thunderheadeng.util.DurationMismatchException;

public abstract class DiscreteSignal
implements Serializable,
Cloneable {
    static final long serialVersionUID = -4339998604821941944L;

    public abstract DiscreteSignal newSignal(double var1, int var3);

    public void set(double d, double d2) {
        this.setSample(this.timeToSample(d), d2);
    }

    public abstract void setSample(int var1, double var2);

    public void setRange(double d, double d2, double d3) {
        this.setRangeOfSamples(this.timeToSample(d), this.timeToSample(d2), d3);
    }

    public void setRangeOfSamples(int n, int n2, double d) {
        int n3 = this.getNumSamples();
        for (int i = n; i < n2 && i < n3; ++i) {
            this.setSample(i, d);
        }
    }

    public double evaluate(double d) {
        return this.evaluateSample(this.timeToSample(d));
    }

    public double[] toArray() {
        int n = this.getNumSamples();
        double[] dArray = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = this.evaluateSample(i);
        }
        return dArray;
    }

    public abstract double evaluateSample(int var1);

    public abstract int getNumSamples();

    public abstract double getSampleInterval();

    public double getDuration() {
        return (double)this.getNumSamples() * this.getSampleInterval();
    }

    public DiscreteSignal extractRange(double d, double d2) {
        int n;
        int n2 = this.timeToSample(d);
        int n3 = this.timeToSample(d2);
        DiscreteSignal discreteSignal = this.newSignal(this.getSampleInterval(), n3 - n2);
        int n4 = 0;
        int n5 = Math.min(n3, 0);
        for (n = n2; n < n5; ++n) {
            discreteSignal.setSample(n4++, 0.0);
        }
        n5 = Math.min(n3, this.getNumSamples());
        while (n < n5) {
            discreteSignal.setSample(n4++, this.evaluateSample(n++));
        }
        while (n < n3) {
            discreteSignal.setSample(n4++, 0.0);
            ++n;
        }
        return discreteSignal;
    }

    public double sampleToTime(int n) {
        return (double)n * this.getSampleInterval();
    }

    public int timeToSample(double d) {
        return (int)Math.floor(d / this.getSampleInterval());
    }

    public double integrate() {
        return this.integrate(0, this.getNumSamples());
    }

    public double integrate(int n, int n2) {
        double d = 0.0;
        for (int i = n; i < n2; ++i) {
            d += this.evaluateSample(i);
        }
        return d * this.getSampleInterval();
    }

    public DiscreteSignal invert() {
        int n = this.getNumSamples();
        for (int i = 0; i < n; ++i) {
            this.setSample(i, -this.evaluateSample(i));
        }
        return this;
    }

    public DiscreteSignal multiply(DiscreteSignal discreteSignal) {
        if (this.getDuration() != discreteSignal.getDuration()) {
            throw new DurationMismatchException();
        }
        if (this.getSampleInterval() != discreteSignal.getSampleInterval()) {
            try {
                discreteSignal = (DiscreteSignal)discreteSignal.clone();
                discreteSignal.resample(this.getSampleInterval());
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                // empty catch block
            }
        }
        for (int i = 0; i < this.getNumSamples(); ++i) {
            this.setSample(i, this.evaluateSample(i) * discreteSignal.evaluateSample(i));
        }
        return this;
    }

    public DiscreteSignal add(DiscreteSignal discreteSignal) {
        if (this.getDuration() != discreteSignal.getDuration()) {
            throw new DurationMismatchException();
        }
        if (this.getSampleInterval() != discreteSignal.getSampleInterval()) {
            try {
                discreteSignal = (DiscreteSignal)discreteSignal.clone();
                discreteSignal.resample(this.getSampleInterval());
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                // empty catch block
            }
        }
        int n = this.getNumSamples();
        for (int i = 0; i < n; ++i) {
            this.setSample(i, this.evaluateSample(i) + discreteSignal.evaluateSample(i));
        }
        return this;
    }

    public DiscreteSignal add(double d) {
        int n = this.getNumSamples();
        for (int i = 0; i < n; ++i) {
            this.setSample(i, this.evaluateSample(i) + d);
        }
        return this;
    }

    public DiscreteSignal multiply(double d) {
        int n = this.getNumSamples();
        for (int i = 0; i < n; ++i) {
            this.setSample(i, this.evaluateSample(i) * d);
        }
        return this;
    }

    public abstract void resample(double var1);
}

