/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class Diff {
    public static final int OP_NOP = 0;
    public static final int OP_ADD = 1;
    public static final int OP_DEL = 2;

    public static int getEditDistance(String string, String string2) {
        int n;
        assert (string != null);
        assert (string2 != null);
        int n2 = string.length() + 1;
        int n3 = string2.length() + 1;
        int[][] nArray = new int[n2][n3];
        for (n = 0; n < n2; ++n) {
            nArray[n][0] = n;
        }
        for (n = 0; n < n3; ++n) {
            nArray[0][n] = n;
        }
        for (n = 1; n < n2; ++n) {
            for (int i = 1; i < n3; ++i) {
                int n4 = string.charAt(n - 1) == string2.charAt(i - 1) ? 0 : 1;
                int n5 = nArray[n - 1][i] + 1;
                int n6 = nArray[n][i - 1] + 1;
                int n7 = nArray[n - 1][i - 1] + n4;
                nArray[n][i] = Math.min(n5, Math.min(n6, n7));
            }
        }
        return nArray[n2 - 1][n3 - 1];
    }

    public static Op[] diff(String string, String string2) {
        ArrayList<Op> arrayList = new ArrayList<Op>();
        Diff.addAdjOps(arrayList, string2, null, Diff.getEditDistance("", string2), "", string, string2);
        Collections.sort(arrayList);
        while (!arrayList.isEmpty()) {
            Op op = (Op)arrayList.remove(0);
            if (op._s.equals(string2)) {
                return Diff.path(op);
            }
            Diff.addAdjOps(arrayList, string2, op, op._d, op._s, op._s1, op._s2);
            Collections.sort(arrayList);
        }
        assert (false);
        return null;
    }

    private static Op[] path(Op op) {
        ArrayList<Op> arrayList = new ArrayList<Op>();
        while (op != null) {
            arrayList.add(0, op);
            op = op._parent;
        }
        return arrayList.toArray(new Op[arrayList.size()]);
    }

    public static List<Boolean> diffToBool(Op[] opArray) {
        ArrayList<Boolean> arrayList = new ArrayList<Boolean>();
        block4: for (int i = 0; i < opArray.length; ++i) {
            Op op = opArray[i];
            switch (op._type) {
                case 0: {
                    arrayList.add(false);
                    continue block4;
                }
                case 1: {
                    arrayList.add(true);
                    continue block4;
                }
            }
        }
        return arrayList;
    }

    public static String diffToStr(Op[] opArray) {
        StringBuffer stringBuffer = new StringBuffer();
        block4: for (Op op : opArray) {
            switch (op._type) {
                case 0: {
                    stringBuffer.append(" ");
                    continue block4;
                }
                case 1: {
                    stringBuffer.append("^");
                    continue block4;
                }
            }
        }
        return stringBuffer.toString();
    }

    public static void addAdjOps(Collection<Op> collection, String string, Op op, int n, String string2, String string3, String string4) {
        Op op2;
        String string5;
        String string6;
        String string7;
        if (string3.length() > 0 && string4.length() > 0) {
            string7 = string2 + string3.charAt(0);
            string6 = string3.substring(1);
            string5 = string4.substring(1);
            op2 = new Op(op, string, 0, 0, string7, string6, string5);
            if (op2._d <= n && string.startsWith(string7)) {
                collection.add(op2);
            }
        }
        if (string4.length() > 0) {
            string7 = string2 + string4.charAt(0);
            string6 = string3;
            string5 = string4.substring(1);
            op2 = new Op(op, string, 1, 1, string7, string6, string5);
            if (op2._d < n && string.startsWith(string7)) {
                collection.add(op2);
            }
        }
        if (string3.length() > 0) {
            string7 = string2;
            string6 = string3.substring(1);
            string5 = string4;
            op2 = new Op(op, string, 2, 1, string7, string6, string5);
            if (op2._d <= n && string.startsWith(string7)) {
                collection.add(op2);
            }
        }
    }

    public static class Op
    implements Comparable<Op> {
        public final Op _parent;
        public final String _s;
        public final String _s1;
        public final String _s2;
        public final int _d;
        public final int _type;
        public final int _cost;

        public Op(Op op, String string, int n, int n2, String string2, String string3, String string4) {
            this._parent = op;
            this._type = n;
            this._s = string2;
            this._cost = n2;
            this._s1 = string3;
            this._s2 = string4;
            this._d = Diff.getEditDistance(string2 + this._s1, string);
        }

        public String toString() {
            return String.format("Op[%s:%s]", this._s, this._s1);
        }

        @Override
        public int compareTo(Op op) {
            return this._cost + this._d - (op._cost + op._d);
        }
    }
}

