/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.util;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import thunderheadeng.gui.Mediator;
import thunderheadeng.util.EmptyTask;
import thunderheadeng.util.IdentityHashSet;
import thunderheadeng.util.Sets;
import thunderheadeng.util.Task;

public class CompositeTask<T extends Mediator>
implements Task {
    private static final int STATE_PREDETERMINEDTASKS = 0;
    private static final int STATE_FIRSTRUNTIMETASKS = 1;
    private static final int STATE_LASTRUNTIMETASKS = 2;
    private static final int STATE_TASKADDINGCOMPLETE = 3;
    private int d_state = 0;
    private List<Task> d_currentAddTasks;
    private List<Task> d_predeterminedTasks;
    private List<Task> d_firstRuntimeTasks;
    private List<Task> d_lastRuntimeTasks;
    private final Set<T> d_mediators;

    protected void queueBeginRuntimeTasks() {
    }

    protected void queueEndRuntimeTasks() {
    }

    public CompositeTask(T t) {
        this(t != null ? Sets.fromArrayIHS(t) : new IdentityHashSet());
    }

    public CompositeTask(Set<T> set) {
        this.d_mediators = new IdentityHashSet<T>(set);
    }

    public final Set<T> getDomains() {
        return this.d_mediators;
    }

    public void addTask(Task task) {
        if (task == EmptyTask.INSTANCE) {
            return;
        }
        assert (this.d_predeterminedTasks == null || this.d_firstRuntimeTasks == null || this.d_lastRuntimeTasks == null);
        if (task == null) {
            return;
        }
        List<Task> list = this.getCurrentTasks();
        list.add(task);
    }

    private List<Task> getCurrentTasks() {
        switch (this.d_state) {
            case 0: {
                if (this.d_predeterminedTasks == null) {
                    this.d_predeterminedTasks = new ArrayList<Task>();
                }
                return this.d_predeterminedTasks;
            }
            case 1: {
                if (this.d_firstRuntimeTasks == null) {
                    this.d_firstRuntimeTasks = new ArrayList<Task>();
                }
                return this.d_firstRuntimeTasks;
            }
            case 2: {
                if (this.d_lastRuntimeTasks == null) {
                    this.d_lastRuntimeTasks = new ArrayList<Task>();
                }
                return this.d_lastRuntimeTasks;
            }
        }
        assert (false);
        return null;
    }

    @Override
    public boolean canUndo() {
        return this.canUndoList(this.d_predeterminedTasks) && this.canUndoList(this.d_firstRuntimeTasks) && this.canUndoList(this.d_lastRuntimeTasks);
    }

    private boolean canUndoList(List<Task> list) {
        if (list == null) {
            return true;
        }
        for (Task task : list) {
            if (task.canUndo()) continue;
            return false;
        }
        return true;
    }

    @Override
    public int getEst() {
        int n = 0;
        int n2 = this.getListEst(this.d_predeterminedTasks);
        int n3 = this.getListEst(this.d_firstRuntimeTasks);
        int n4 = this.getListEst(this.d_lastRuntimeTasks);
        if (n2 > n) {
            n = n2;
        }
        if (n3 > n) {
            n = n3;
        }
        if (n4 > n) {
            n = n4;
        }
        return n;
    }

    public int getListEst(List<Task> list) {
        int n = 0;
        if (list == null) {
            return n;
        }
        for (Task task : list) {
            if (task.getEst() <= n) continue;
            n = task.getEst();
        }
        return n;
    }

    @Override
    public void undo() {
        this.pauseUpdates();
        this.undoList(this.d_lastRuntimeTasks);
        this.undoList(this.d_predeterminedTasks);
        this.undoList(this.d_firstRuntimeTasks);
        this.resumeUpdates();
    }

    private void undoList(List<Task> list) {
        if (list == null) {
            return;
        }
        ListIterator<Task> listIterator = list.listIterator(list.size());
        while (listIterator.hasPrevious()) {
            listIterator.previous().undo();
        }
    }

    @Override
    public void run() {
        this.pauseUpdates();
        if (this.d_state != 3) {
            this.d_state = 1;
            this.queueBeginRuntimeTasks();
            this.d_state = 2;
            this.queueEndRuntimeTasks();
            this.d_state = 3;
        }
        this.runList(this.d_firstRuntimeTasks);
        this.runList(this.d_predeterminedTasks);
        this.runList(this.d_lastRuntimeTasks);
        this.resumeUpdates();
    }

    private void runList(List<Task> list) {
        if (list == null) {
            return;
        }
        for (Task task : list) {
            task.run();
        }
    }

    protected void pauseUpdates(boolean bl) {
        for (Mediator mediator : this.d_mediators) {
            mediator.pauseUpdates(bl);
        }
    }

    protected void pauseUpdates() {
        for (Mediator mediator : this.d_mediators) {
            mediator.pauseUpdates();
        }
    }

    protected void resumeUpdates() {
        for (Mediator mediator : this.d_mediators) {
            mediator.resumeUpdates();
        }
    }
}

