/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.util;

import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import thunderheadeng.util.AEventRec;
import thunderheadeng.util.CompositeIterator;
import thunderheadeng.util.EmptyEventRec;
import thunderheadeng.util.IEventRecord;
import thunderheadeng.util.Predicates;

public class CompositeEvtRec<ObjT>
extends AEventRec<ObjT> {
    private final List<? extends IEventRecord<? extends ObjT>> d_channels;
    private Set<Object> d_cachedChanges;

    public CompositeEvtRec(Collection<? extends IEventRecord<? extends ObjT>> collection) {
        this.d_channels = collection instanceof List ? (List<Object>)collection : new ArrayList<IEventRecord<? extends ObjT>>(collection);
    }

    @Override
    public IEventRecord<ObjT> filter(Predicate<? super ObjT> predicate) {
        if (Predicates.alwaysTrue(predicate)) {
            return this;
        }
        if (Predicates.alwaysFalse(predicate)) {
            return EmptyEventRec.INSTANCE;
        }
        ArrayList<IEventRecord<? super ObjT>> arrayList = new ArrayList<IEventRecord<? super ObjT>>(this.d_channels.size());
        for (IEventRecord<? super ObjT> iEventRecord : this.d_channels) {
            arrayList.add(iEventRecord.filter(predicate));
        }
        return new CompositeEvtRec<ObjT>(arrayList);
    }

    @Override
    public boolean isModified() {
        for (IEventRecord<ObjT> iEventRecord : this.d_channels) {
            if (!iEventRecord.isModified()) continue;
            return true;
        }
        return false;
    }

    @Override
    public Set<ObjT> getAddedObjs() {
        return new CompAddSet();
    }

    @Override
    public Set<ObjT> getRemovedObjs() {
        return new CompRemoveSet();
    }

    @Override
    public Set<Object> getChanges() {
        if (this.d_cachedChanges == null) {
            this.d_cachedChanges = new LinkedHashSet<Object>();
            for (IEventRecord<ObjT> iEventRecord : this.d_channels) {
                this.d_cachedChanges.addAll(iEventRecord.getChanges());
            }
        }
        return this.d_cachedChanges;
    }

    @Override
    public Set<ObjT> getChangedObjs(Object ... objectArray) {
        return new CompChangedObjsSet(objectArray);
    }

    @Override
    public Set<ObjT> getChangedObjs(Predicate<Object> predicate) {
        return new CompChangedObjsSet2(predicate);
    }

    @Override
    public boolean isChanged(Object object) {
        for (IEventRecord<ObjT> iEventRecord : this.d_channels) {
            if (!iEventRecord.isChanged(object)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isChanged(Object object, Object object2) {
        for (IEventRecord<ObjT> iEventRecord : this.d_channels) {
            if (!iEventRecord.isChanged(object, object2)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsChange(Object object) {
        for (IEventRecord<ObjT> iEventRecord : this.d_channels) {
            if (!iEventRecord.containsChange(object)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void getChanges(Object object, Collection<Object> collection) {
        for (IEventRecord<ObjT> iEventRecord : this.d_channels) {
            if (!iEventRecord.isChanged(object)) continue;
            iEventRecord.getChanges(object, collection);
            return;
        }
    }

    private class CompChangedObjsSet2
    extends CompositeSet<ObjT> {
        private final Predicate<Object> d_filter;

        public CompChangedObjsSet2(Predicate<Object> predicate) {
            this.d_filter = predicate;
        }

        @Override
        protected Set<? extends ObjT> getSet(IEventRecord<? extends ObjT> iEventRecord) {
            return iEventRecord.getChangedObjs(this.d_filter);
        }
    }

    private class CompChangedObjsSet
    extends CompositeSet<ObjT> {
        private final Object[] d_changes;

        public CompChangedObjsSet(Object[] objectArray) {
            this.d_changes = objectArray;
        }

        @Override
        protected Set<? extends ObjT> getSet(IEventRecord<? extends ObjT> iEventRecord) {
            return iEventRecord.getChangedObjs(this.d_changes);
        }
    }

    private class CompRemoveSet
    extends CompositeSet<ObjT> {
        private CompRemoveSet() {
        }

        @Override
        protected Set<? extends ObjT> getSet(IEventRecord<? extends ObjT> iEventRecord) {
            return iEventRecord.getRemovedObjs();
        }
    }

    private class CompAddSet
    extends CompositeSet<ObjT> {
        private CompAddSet() {
        }

        @Override
        protected Set<? extends ObjT> getSet(IEventRecord<? extends ObjT> iEventRecord) {
            return iEventRecord.getAddedObjs();
        }
    }

    private abstract class CompositeSet<E>
    extends AbstractSet<E> {
        private final Map<IEventRecord<? extends ObjT>, Set<? extends E>> d_cachedSets = new IdentityHashMap();

        protected abstract Set<? extends E> getSet(IEventRecord<? extends ObjT> var1);

        protected Set<? extends E> getCachedSet(IEventRecord<? extends ObjT> iEventRecord) {
            Set<Object> set = this.d_cachedSets.get(iEventRecord);
            if (set == null) {
                set = this.getSet(iEventRecord);
                this.d_cachedSets.put(iEventRecord, set);
            }
            return set;
        }

        @Override
        public Iterator<E> iterator() {
            ArrayList<Set<E>> arrayList = new ArrayList<Set<E>>(CompositeEvtRec.this.d_channels.size());
            for (IEventRecord iEventRecord : CompositeEvtRec.this.d_channels) {
                arrayList.add(this.getCachedSet(iEventRecord));
            }
            return new CompositeIterator(arrayList);
        }

        @Override
        public int size() {
            int n = 0;
            for (IEventRecord iEventRecord : CompositeEvtRec.this.d_channels) {
                n += this.getCachedSet(iEventRecord).size();
            }
            return n;
        }

        @Override
        public boolean contains(Object object) {
            for (IEventRecord iEventRecord : CompositeEvtRec.this.d_channels) {
                if (!this.getCachedSet(iEventRecord).contains(object)) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean isEmpty() {
            for (IEventRecord iEventRecord : CompositeEvtRec.this.d_channels) {
                if (this.getCachedSet(iEventRecord).isEmpty()) continue;
                return false;
            }
            return true;
        }
    }
}

