/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.util;

import java.math.BigInteger;
import java.util.AbstractCollection;
import java.util.Iterator;

public class Bag<E>
extends AbstractCollection<E> {
    private Object d_removeMark;
    private int d_removeMarkCount = 0;
    private static final int SZ_INIT = 17;
    private Object[] d_data = new Object[17];
    private double d_loadFactor = 0.49;
    private int d_size = 0;

    public Bag() {
        this.d_removeMark = new Object();
    }

    @Override
    public boolean add(E e) {
        if (e == null) {
            throw new NullPointerException();
        }
        if ((double)this.d_size > (double)this.d_data.length * this.d_loadFactor) {
            this.d_data = Bag.rehash(this);
        }
        if (!this.contains(e)) {
            this.d_data[Bag.probeForInsertIx((Object[])this.d_data, e)] = e;
            ++this.d_size;
            return true;
        }
        return false;
    }

    @Override
    public void clear() {
        this.d_data = new Object[17];
        this.d_size = 0;
        this.d_removeMarkCount = 0;
    }

    @Override
    public boolean remove(Object object) {
        return Bag.remove(this, Bag.find(this.d_data, object));
    }

    private static boolean remove(Bag bag, int n) {
        if (n != -1) {
            bag.d_data[n] = bag.d_removeMark;
            ++bag.d_removeMarkCount;
            --bag.d_size;
            return true;
        }
        return false;
    }

    @Override
    public boolean contains(Object object) {
        return Bag.find(this.d_data, object) != -1;
    }

    private static int probeForInsertIx(Object[] objectArray, Object object) {
        int n = object.hashCode() % objectArray.length;
        int n2 = 1;
        while (objectArray[n] != null) {
            n = (n + n2 * n2) % objectArray.length;
            ++n2;
        }
        return n;
    }

    private static int find(Object[] objectArray, Object object) {
        if (object == null) {
            return -1;
        }
        int n = object.hashCode() % objectArray.length;
        int n2 = 1;
        while (objectArray[n] != object) {
            if (objectArray[n] == null) {
                return -1;
            }
            n = (n + n2 * n2) % objectArray.length;
            ++n2;
        }
        return n;
    }

    private static Object[] rehash(Bag bag) {
        String string = Integer.toString(bag.d_data.length * 2 - 1);
        int n = new BigInteger(string).nextProbablePrime().intValue();
        Object[] objectArray = new Object[n];
        Iterator iterator = Bag.iterator(bag);
        while (iterator.hasNext()) {
            Object e = iterator.next();
            objectArray[Bag.probeForInsertIx((Object[])objectArray, e)] = e;
        }
        bag.d_removeMarkCount = 0;
        return objectArray;
    }

    @Override
    public Iterator<E> iterator() {
        return Bag.iterator(this);
    }

    private static <E> Iterator<E> iterator(final Bag bag) {
        return new Iterator<E>(){
            int ix = this.findNext(0);
            int current = -1;

            private int findNext(int n) {
                for (int i = n; i < bag.d_data.length; ++i) {
                    if (bag.d_data[i] == null) continue;
                    return i;
                }
                return bag.d_data.length;
            }

            @Override
            public boolean hasNext() {
                return this.ix < bag.d_data.length;
            }

            @Override
            public E next() {
                this.current = this.ix;
                this.ix = this.findNext(this.current + 1);
                assert (bag.d_data[this.current] != null);
                return bag.d_data[this.current];
            }

            @Override
            public void remove() {
                Bag.remove(bag, this.current);
            }
        };
    }

    @Override
    public int size() {
        return this.d_size;
    }
}

