/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.units;

import java.io.Serializable;
import java.util.List;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import org.jscience.physics.units.Converter;
import org.jscience.physics.units.Unit;
import thunderheadeng.geometry.AABox;
import thunderheadeng.units.UnitDouble;

public class UnitPoint3D
implements Serializable {
    static final long serialVersionUID = 1L;
    private final double x;
    private final double y;
    private final double z;
    private final Unit d_unit;

    public UnitPoint3D(List<UnitDouble> list) {
        this(list.get(0), list.get(1), list.get(2));
    }

    public UnitPoint3D(UnitDouble ... unitDoubleArray) {
        this(unitDoubleArray[0], unitDoubleArray[1], unitDoubleArray[2]);
    }

    public UnitPoint3D(UnitDouble unitDouble, UnitDouble unitDouble2, UnitDouble unitDouble3) {
        this(unitDouble.getValueNoUnit(), unitDouble2.getValue(unitDouble.getUnit()), unitDouble3.getValue(unitDouble.getUnit()), unitDouble.getUnit());
    }

    public UnitPoint3D(double d, double d2, double d3, Unit unit) {
        this.x = d;
        this.y = d2;
        this.z = d3;
        this.d_unit = unit;
    }

    public UnitPoint3D(double[] dArray, Unit unit) {
        this(dArray[0], dArray[1], dArray[2], unit);
    }

    public UnitPoint3D(Point3d point3d, Unit unit) {
        this(point3d.x, point3d.y, point3d.z, unit);
    }

    public UnitPoint3D(Tuple3d tuple3d, Unit unit) {
        this(tuple3d.x, tuple3d.y, tuple3d.z, unit);
    }

    public void add(AABox aABox, Unit unit) {
        aABox.addPoint(this.x(unit), this.y(unit), this.z(unit));
    }

    public UnitPoint3D convert(Unit unit) {
        Converter converter = this.d_unit.getConverterTo(unit);
        return new UnitPoint3D(converter.convert(this.x), converter.convert(this.y), converter.convert(this.z), unit);
    }

    public static UnitPoint3D convert(Point3d point3d, Unit unit, Unit unit2) {
        Converter converter = unit.getConverterTo(unit2);
        return new UnitPoint3D(converter.convert(point3d.x), converter.convert(point3d.y), converter.convert(point3d.z), unit2);
    }

    public Point3d getValue(Unit unit) {
        assert (this.d_unit != null);
        if (unit.equals(this.d_unit)) {
            return new Point3d(this.x, this.y, this.z);
        }
        return new Point3d(UnitDouble.convert(this.x, this.d_unit, unit), UnitDouble.convert(this.y, this.d_unit, unit), UnitDouble.convert(this.z, this.d_unit, unit));
    }

    public Point3d getPoint3dValue(Unit unit) {
        return this.getValue(unit);
    }

    public Vector3d getVector3dValue(Unit unit) {
        assert (this.d_unit != null);
        if (unit.equals(this.d_unit)) {
            return new Vector3d(this.x, this.y, this.z);
        }
        return new Vector3d(UnitDouble.convert(this.x, this.d_unit, unit), UnitDouble.convert(this.y, this.d_unit, unit), UnitDouble.convert(this.z, this.d_unit, unit));
    }

    public void getData(double[] dArray, Unit unit) {
        assert (dArray.length >= 3);
        dArray[0] = this.x(unit);
        dArray[1] = this.y(unit);
        dArray[2] = this.z(unit);
    }

    public UnitDouble xu() {
        return new UnitDouble(this.x, this.d_unit);
    }

    public UnitDouble yu() {
        return new UnitDouble(this.y, this.d_unit);
    }

    public UnitDouble zu() {
        return new UnitDouble(this.z, this.d_unit);
    }

    public double x(Unit unit) {
        return UnitDouble.convert(this.x, this.d_unit, unit);
    }

    public double y(Unit unit) {
        return UnitDouble.convert(this.y, this.d_unit, unit);
    }

    public double z(Unit unit) {
        return UnitDouble.convert(this.z, this.d_unit, unit);
    }

    public double x() {
        return this.x;
    }

    public double y() {
        return this.y;
    }

    public double z() {
        return this.z;
    }

    public Unit getUnit() {
        return this.d_unit;
    }

    public UnitPoint3D add(UnitPoint3D unitPoint3D) {
        if (unitPoint3D.x == 0.0 && unitPoint3D.y == 0.0 && unitPoint3D.z == 0.0) {
            return this;
        }
        return new UnitPoint3D(this.x + unitPoint3D.x(this.d_unit), this.y + unitPoint3D.y(this.d_unit), this.z + unitPoint3D.z(this.d_unit), this.d_unit);
    }

    public UnitPoint3D sub(UnitPoint3D unitPoint3D) {
        if (unitPoint3D.x == 0.0 && unitPoint3D.y == 0.0 && unitPoint3D.z == 0.0) {
            return this;
        }
        return new UnitPoint3D(this.x - unitPoint3D.x(this.d_unit), this.y - unitPoint3D.y(this.d_unit), this.z - unitPoint3D.z(this.d_unit), this.d_unit);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof UnitPoint3D)) {
            return false;
        }
        UnitPoint3D unitPoint3D = (UnitPoint3D)object;
        if (this.d_unit.equals(unitPoint3D.d_unit)) {
            return this.x == unitPoint3D.x && this.y == unitPoint3D.y && this.z == unitPoint3D.z;
        }
        return UnitDouble.areCompatible(this.d_unit, unitPoint3D.d_unit) && this.x == unitPoint3D.x(this.d_unit) && this.y == unitPoint3D.y(this.d_unit) && this.z == unitPoint3D.z(this.d_unit);
    }

    public int hashCode() {
        return UnitDouble.hashCode(this.x + this.y + this.z, this.d_unit);
    }

    public String toString() {
        return "(" + this.x + "," + this.y + "," + this.z + ") " + this.d_unit;
    }
}

