/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.scene3d.tools;

import java.awt.event.MouseEvent;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import javax.vecmath.Point3d;
import thunderheadeng.scene3d.navtools.CursorTool;

public class MouseHistory {
    private final Deque<Point> d_history = new ArrayDeque<Point>();
    private final List<IListener> d_listeners = new ArrayList<IListener>();
    private boolean d_duplicatePointsAllowed = false;

    public void setDuplicatesAllowed(boolean bl) {
        this.d_duplicatePointsAllowed = bl;
    }

    public boolean getDuplicatesAllowed() {
        return this.d_duplicatePointsAllowed;
    }

    public void addListener(IListener iListener) {
        this.d_listeners.remove(iListener);
        this.d_listeners.add(iListener);
    }

    public void removeListener(IListener iListener) {
        this.d_listeners.remove(iListener);
    }

    public void reset() {
        this.d_history.clear();
    }

    public Point3d getLastCommitted() {
        Point point = this.getLastCommittedPoint();
        return point != null ? point.p : null;
    }

    public Point getLastCommittedPoint() {
        if (!this.d_history.isEmpty()) {
            Point point;
            Point point2 = !this.d_history.peekLast().committed ? this.d_history.removeLast() : null;
            Point point3 = point = !this.d_history.isEmpty() ? this.d_history.peekLast() : null;
            if (point2 != null) {
                this.d_history.addLast(point2);
            }
            return point;
        }
        return null;
    }

    public void mouseMoved(CursorTool cursorTool, MouseEvent mouseEvent, CursorTool.SnapInfo snapInfo) {
        if (snapInfo == null) {
            return;
        }
        this.addPoint(snapInfo, !snapInfo.snaps.isEmpty(), false, false);
    }

    public void mousePressed(CursorTool cursorTool, MouseEvent mouseEvent, CursorTool.SnapInfo snapInfo) {
        if (snapInfo == null) {
            return;
        }
        if (mouseEvent.getButton() == 1) {
            this.addPoint(snapInfo, !snapInfo.snaps.isEmpty(), true, false);
        }
    }

    public void mouseDragged(CursorTool cursorTool, MouseEvent mouseEvent, CursorTool.SnapInfo snapInfo) {
        if (snapInfo == null) {
            return;
        }
        if (cursorTool.isDragging(1) && cursorTool.aboveTolerance(0)) {
            this.addPoint(snapInfo, !snapInfo.snaps.isEmpty(), false, true);
        }
    }

    public void mouseReleased(CursorTool cursorTool, MouseEvent mouseEvent, CursorTool.SnapInfo snapInfo) {
        if (snapInfo == null) {
            return;
        }
        if (mouseEvent.getButton() == 1 && cursorTool.dragAboveTolerance(0)) {
            this.addPoint(snapInfo, !snapInfo.snaps.isEmpty(), true, true);
        }
    }

    public void finalizePoints() {
        if (!this.d_history.isEmpty() && !this.d_history.peekLast().committed) {
            this.d_history.removeLast();
            if (!this.d_history.isEmpty()) {
                this.d_history.peekLast().committed = true;
            }
        }
    }

    public void addPoint(CursorTool.SnapInfo snapInfo, boolean bl) {
        this.addPoint(snapInfo, true, bl, false);
    }

    protected void addPoint(CursorTool.SnapInfo snapInfo, boolean bl, boolean bl2, boolean bl3) {
        if (snapInfo != null && !snapInfo.constrained.isEmpty()) {
            if (!this.d_history.isEmpty() && !this.d_history.peekLast().committed) {
                this.d_history.removeLast();
            }
            if (this.d_history.isEmpty() || this.d_duplicatePointsAllowed || !this.d_history.peekLast().p.equals(snapInfo.constrained.getLast())) {
                Point point = new Point(snapInfo, bl, bl3, bl2);
                this.d_history.addLast(point);
                for (IListener iListener : this.d_listeners) {
                    iListener.pointAdded(this, point);
                }
            }
        }
    }

    public int size() {
        return this.d_history.size();
    }

    public int committedSize() {
        return !this.d_history.isEmpty() && !this.d_history.getLast().committed ? this.d_history.size() - 1 : this.d_history.size();
    }

    public Deque<Point> getHistory() {
        return this.d_history;
    }

    public List<Point3d> getAllPoints() {
        ArrayList<Point3d> arrayList = new ArrayList<Point3d>(this.d_history.size());
        for (Point point : this.d_history) {
            arrayList.add(point.p);
        }
        return arrayList;
    }

    public List<Point3d> getCommittedPoints() {
        ArrayList<Point3d> arrayList = new ArrayList<Point3d>(this.d_history.size());
        for (Point point : this.d_history) {
            if (!point.committed) continue;
            arrayList.add(point.p);
        }
        return arrayList;
    }

    public Point3d getTemporaryPoint() {
        return !this.d_history.isEmpty() && !this.d_history.getLast().committed ? this.d_history.getLast().p : null;
    }

    public static interface IListener {
        public void pointAdded(MouseHistory var1, Point var2);
    }

    public static class Point {
        public final Point3d p;
        public final CursorTool.SnapInfo snap;
        public final boolean snapped;
        public final boolean dragged;
        public boolean committed;

        public Point(CursorTool.SnapInfo snapInfo, boolean bl, boolean bl2, boolean bl3) {
            this.p = snapInfo.constrained.getLast();
            this.snap = snapInfo;
            this.snapped = bl;
            this.committed = bl3;
            this.dragged = bl2;
        }

        public boolean equals(Object object) {
            return object == this || object instanceof Point && ((Point)object).p.epsilonEquals(this.p, 1.0E-9);
        }
    }
}

