/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.scene3d.picking;

public class RayPointProx
implements Comparable<RayPointProx> {
    private final double d_zDist;
    private final double d_rDist;
    private final double d_rcomp;
    private final double d_zcomp;

    public RayPointProx(double d, double d2) {
        assert (!Double.isNaN(d));
        assert (!Double.isNaN(d2));
        this.d_zDist = d;
        this.d_rDist = d2;
        this.d_rcomp = Math.floor(d2 * 1000000.0);
        this.d_zcomp = Math.floor(d * 1000000.0);
    }

    @Override
    public int compareTo(RayPointProx rayPointProx) {
        if (rayPointProx == this) {
            return 0;
        }
        int n = Double.compare(this.d_rcomp, rayPointProx.d_rcomp);
        if (n != 0) {
            return n;
        }
        int n2 = Double.compare(this.d_zcomp, rayPointProx.d_zcomp);
        if (n2 != 0) {
            return n2;
        }
        return 0;
    }

    public double getZDist() {
        return this.d_zDist;
    }

    public double getRDist() {
        return this.d_rDist;
    }
}

