/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.scene3d.picking;

import java.util.function.Consumer;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.ConvexHull;
import thunderheadeng.geometry.GeomConstants;
import thunderheadeng.geometry.Inter3D;
import thunderheadeng.geometry.Util3D;
import thunderheadeng.geometry.objs.LineSeg;
import thunderheadeng.geometry.search.ITest;
import thunderheadeng.scene3d.picking.GeomType;
import thunderheadeng.scene3d.picking.IBoxCollector;
import thunderheadeng.scene3d.picking.IIsectCollector;
import thunderheadeng.scene3d.picking.IIsectFilter;
import thunderheadeng.scene3d.picking.IPickable;
import thunderheadeng.scene3d.picking.LineConstraint;

public class OrthoSnap
implements IPickable {
    public final Point3d origin;
    public final Vector3d[] axes;

    public OrthoSnap(Point3d point3d) {
        this(point3d, GeomConstants.VEC3D_XPOS, GeomConstants.VEC3D_YPOS, GeomConstants.VEC3D_ZPOS);
    }

    public OrthoSnap(Point3d point3d, Vector3d ... vector3dArray) {
        this.origin = point3d;
        this.axes = vector3dArray;
    }

    @Override
    public void pickPoints(IIsectCollector iIsectCollector, IIsectFilter iIsectFilter, Point3d point3d, Point3d point3d2, Vector3d vector3d, ITest<AABox> iTest) {
        for (Vector3d vector3d2 : this.axes) {
            double[] dArray;
            LineConstraint lineConstraint = new LineConstraint(this.origin, vector3d2);
            if (!iIsectFilter.acceptPickObject(lineConstraint) || !iIsectFilter.acceptGeomType(lineConstraint, GeomType.EDGE) || (dArray = Inter3D.lineLineProximityT(point3d, vector3d, this.origin, vector3d2, 1.0E-9)) == null) continue;
            Point3d point3d3 = Util3D.linePoint(this.origin, vector3d2, dArray[1]);
            iIsectCollector.addInfinite(lineConstraint, point3d3, GeomType.EDGE, new LineSeg(this.origin, Util3D.add(this.origin, (Tuple3d)vector3d2)));
        }
    }

    @Override
    public void pickBox(IBoxCollector iBoxCollector, IIsectFilter iIsectFilter, ConvexHull convexHull) {
    }

    @Override
    public void getAll(Consumer<Object> consumer, IIsectFilter iIsectFilter) {
    }
}

