/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.scene3d.picking;

import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import thunderheadeng.geometry.Inter3D;
import thunderheadeng.geometry.Util3D;
import thunderheadeng.scene3d.picking.ISnapConstraint;
import thunderheadeng.util.Pair;

public class LineConstraint
implements ISnapConstraint {
    public final Point3d p;
    public final Vector3d dir;

    public LineConstraint(Point3d point3d, Vector3d vector3d) {
        this.p = point3d;
        this.dir = vector3d;
    }

    @Override
    public Pair<Point3d, Point3d> snapRay(Point3d point3d, Vector3d vector3d) {
        double[] dArray = Inter3D.lineLineProximityT(point3d, vector3d, this.p, this.dir, 1.0E-9);
        if (dArray == null || Double.isNaN(dArray[1]) || Double.isNaN(dArray[0])) {
            return null;
        }
        if (dArray[0] < 0.0) {
            dArray[0] = 0.0;
            dArray[1] = Inter3D.nearestTOnLine(this.p, this.dir, point3d);
        }
        return new Pair<Point3d, Point3d>(Util3D.linePoint(point3d, vector3d, dArray[0]), Util3D.linePoint(this.p, this.dir, dArray[1]));
    }

    @Override
    public Point3d snapPoint(Point3d point3d) {
        return Inter3D.nearestPointOnLine(this.p, this.dir, point3d);
    }

    @Override
    public ISnapConstraint transform(Matrix4d matrix4d) {
        Point3d point3d = Util3D.xform(matrix4d, this.p);
        Vector3d vector3d = Util3D.xform(matrix4d, this.dir);
        return new LineConstraint(point3d, vector3d);
    }
}

