/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.scene3d.picking;

import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.ConvexHull;
import thunderheadeng.geometry.objs.IFace;
import thunderheadeng.geometry.objs.IPrimitive;
import thunderheadeng.geometry.search.ITest;
import thunderheadeng.scene3d.geom.DisplayGeom;
import thunderheadeng.scene3d.geom.IPrimProps;
import thunderheadeng.scene3d.geom.IPropsSrc;
import thunderheadeng.scene3d.geom.UniformProps;
import thunderheadeng.scene3d.picking.GeomType;
import thunderheadeng.scene3d.picking.IBoxCollector;
import thunderheadeng.scene3d.picking.IIsectCollector;
import thunderheadeng.scene3d.picking.IIsectFilter;
import thunderheadeng.util.CancelledException;
import thunderheadeng.util.Pair;
import thunderheadeng.util.TaskProgress;

public interface IPickable {
    public static final IPropsSrc DEF_PROPS = new UniformProps(IPrimProps.DEF);

    public void pickPoints(IIsectCollector var1, IIsectFilter var2, Point3d var3, Point3d var4, Vector3d var5, ITest<AABox> var6);

    public void pickBox(IBoxCollector var1, IIsectFilter var2, ConvexHull var3);

    @Deprecated
    default public void getAll(IBoxCollector iBoxCollector, IIsectFilter iIsectFilter) {
    }

    public void getAll(Consumer<Object> var1, IIsectFilter var2);

    public static void pickPoints(Object object, Supplier<DisplayGeom> supplier, IIsectCollector iIsectCollector, IIsectFilter iIsectFilter, Point3d point3d, Point3d point3d2, Vector3d vector3d, ITest<AABox> iTest) {
        if (!iIsectFilter.acceptPickObject(object)) {
            return;
        }
        DisplayGeom displayGeom = supplier.get();
        displayGeom.node.pickPoints(IPickable.convertCollector(iIsectCollector, displayGeom.props), iIsectFilter, object, point3d, point3d2, vector3d, iTest);
    }

    public static void pickBox(Object object, Supplier<DisplayGeom> supplier, IBoxCollector iBoxCollector, IIsectFilter iIsectFilter, ConvexHull convexHull) {
        if (!iIsectFilter.acceptPickObject(object)) {
            return;
        }
        DisplayGeom displayGeom = supplier.get();
        try {
            displayGeom.node.pickBox(object, iIsectFilter, convexHull, IPickable.convertCollector(iBoxCollector, displayGeom.props));
        }
        catch (CancelledException cancelledException) {
            // empty catch block
        }
    }

    public static void getAll(Object object, Consumer<Object> consumer, IIsectFilter iIsectFilter) {
        if (iIsectFilter.acceptPickObject(object)) {
            consumer.accept(object);
        }
    }

    public static thunderheadeng.geometry.objs.IIsectCollector convertCollector(final IIsectCollector iIsectCollector, final IPropsSrc iPropsSrc) {
        return new thunderheadeng.geometry.objs.IIsectCollector(){

            @Override
            public void addNonFace(Object object, Point3d point3d, GeomType geomType) {
                iIsectCollector.addNonFace(object, point3d, geomType);
            }

            @Override
            public void addFace(Object object, Point3d point3d, int n, Supplier<IFace> supplier, Supplier<Vector3d> supplier2) {
                iIsectCollector.addFace(object, point3d, supplier, supplier2, iPropsSrc.get(n));
            }

            @Override
            public void addInfinite(Object object, Point3d point3d, GeomType geomType, IPrimitive iPrimitive) {
                iIsectCollector.addInfinite(object, point3d, geomType, iPrimitive);
            }

            @Override
            public TaskProgress getProgress() {
                return iIsectCollector.getProgress();
            }
        };
    }

    public static thunderheadeng.geometry.objs.IBoxCollector convertCollector(final IBoxCollector iBoxCollector, final IPropsSrc iPropsSrc) {
        return new thunderheadeng.geometry.objs.IBoxCollector(){

            @Override
            public void addNonFace(Object object) throws CancelledException {
                iBoxCollector.addNonFace(object);
            }

            @Override
            public void addFace(Object object, int n, Supplier<Pair<Point3d, Vector3d>> supplier) throws CancelledException {
                iBoxCollector.addFace(object, supplier, iPropsSrc.get(n));
            }
        };
    }
}

