/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.scene3d.picking;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.BooleanSupplier;
import java.util.function.DoubleConsumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point2d;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.Box3d;
import thunderheadeng.geometry.ConvexHull;
import thunderheadeng.geometry.Inter3D;
import thunderheadeng.geometry.LineSegRTreeTest;
import thunderheadeng.geometry.Plane3d;
import thunderheadeng.geometry.Ray3d;
import thunderheadeng.geometry.Util3D;
import thunderheadeng.geometry.objs.IFace;
import thunderheadeng.geometry.objs.IPrimitive;
import thunderheadeng.geometry.search.Containment;
import thunderheadeng.geometry.search.IResult;
import thunderheadeng.geometry.search.ITest;
import thunderheadeng.scene3d.geom.IPrimProps;
import thunderheadeng.scene3d.nativebuffered.View;
import thunderheadeng.scene3d.picking.DefaultFilter;
import thunderheadeng.scene3d.picking.GeomType;
import thunderheadeng.scene3d.picking.IBoxCollector;
import thunderheadeng.scene3d.picking.IIsectCollector;
import thunderheadeng.scene3d.picking.IIsectFilter;
import thunderheadeng.scene3d.picking.IPickConfig;
import thunderheadeng.scene3d.picking.IPickRoot;
import thunderheadeng.scene3d.picking.IPickSession;
import thunderheadeng.scene3d.picking.IPickable;
import thunderheadeng.scene3d.picking.IsectInfo;
import thunderheadeng.scene3d.picking.RayPointProx;
import thunderheadeng.util.CancelledException;
import thunderheadeng.util.Filters;
import thunderheadeng.util.LinkedIdentityHashSet;
import thunderheadeng.util.Pair;
import thunderheadeng.util.TaskProgress;
import thunderheadeng.util.theTimer;
import thunderheadeng.util.theUtil;

public class GeomPicker {
    private static final boolean PROFILE = false;
    private final IPickRoot d_geometry;
    private final View d_view;
    private boolean d_occlusionFilterEnabled;
    private final theTimer d_timer = null;
    private final Runnable profileStart = () -> {};
    private final Runnable profileEnd = () -> {};
    public static final IIsectFilter ACCEPT_ALL = new DefaultFilter();

    public GeomPicker(IPickRoot iPickRoot, View view) {
        this.d_geometry = iPickRoot;
        this.d_view = view;
        this.d_occlusionFilterEnabled = true;
    }

    public void setOcclusionFilteringEnabled(boolean bl) {
        this.d_occlusionFilterEnabled = bl;
    }

    public boolean isOcclusionFilteringEnabled() {
        return this.d_occlusionFilterEnabled;
    }

    public IPickRoot getGeomSource() {
        return this.d_geometry;
    }

    @Deprecated
    public IsectInfo pickClosest(Mode mode, Point2d point2d, double d) {
        return this.pickClosest(mode, point2d, d, ACCEPT_ALL);
    }

    @Deprecated
    public IsectInfo pickClosest(Mode mode, Point2d point2d, double d, IIsectFilter iIsectFilter) {
        try {
            Collection<IsectInfo> collection = this.pick(new TaskProgress(), mode, point2d, d, iIsectFilter);
            Iterator<IsectInfo> iterator = collection.iterator();
            if (!iterator.hasNext()) {
                return null;
            }
            return iterator.next();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public Collection<IsectInfo> pick(TaskProgress taskProgress, Mode mode, Point2d point2d, double d) {
        return this.pick(taskProgress, mode, point2d, d, ACCEPT_ALL);
    }

    private static boolean acceptsOnly(IIsectFilter iIsectFilter, GeomType geomType) {
        if (!iIsectFilter.acceptGeomType(null, geomType)) {
            return false;
        }
        for (GeomType geomType2 : GeomType.values()) {
            if (geomType2 == geomType || !iIsectFilter.acceptGeomType(null, geomType2)) continue;
            return false;
        }
        return true;
    }

    public Collection<IsectInfo> pick(TaskProgress taskProgress, Mode mode, Point2d point2d, double d, IIsectFilter iIsectFilter) {
        this.profileStart.run();
        if (d > 0.0 && GeomPicker.acceptsOnly(iIsectFilter, GeomType.FACE)) {
            d = 0.0;
        }
        Ray3d ray3d = this.getPickRay(point2d);
        ArrayList<IsectInfo> arrayList = new ArrayList<IsectInfo>();
        IPickSession iPickSession = this.d_geometry.beginPicking();
        for (IPickConfig iPickConfig : iPickSession.getPickConfigs()) {
            IRayProxDetector iRayProxDetector;
            ITest<AABox> iTest;
            Object object;
            Object object2;
            Ray3d ray3d2 = GeomPicker.trim(ray3d, iPickConfig.getClippingRegion());
            if (ray3d2 == null) continue;
            if (d > 0.0) {
                object2 = this.d_view.toFrustum(point2d, d);
                object = GeomPicker.intersect((Box3d)object2, iPickConfig.getClippingRegion());
                iTest = new CHTest((ConvexHull)object);
                iRayProxDetector = new RayTolProxDetector(this.d_view, ray3d.origin, point2d, d, (ConvexHull)object);
            } else {
                iTest = new LineSegRTreeTest(ray3d2.p1(), ray3d2.p2());
                iRayProxDetector = new RayProxDetector(ray3d.origin, ray3d2);
            }
            object2 = new VisibilityFilter(iIsectFilter, iPickSession, iPickConfig);
            object = new RaySearchResult(taskProgress, this.d_view, iPickSession, mode, (IIsectFilter)object2, ray3d2, iTest, iRayProxDetector, iPickConfig);
            iPickSession.find(iPickConfig, iTest, (IResult<IPickable>)object);
            arrayList.addAll(((RaySearchResult)object).getIsects());
        }
        IsectSorter isectSorter = new IsectSorter(mode, iPickSession);
        Collections.sort(arrayList, isectSorter);
        Collection<IsectInfo> collection = !this.d_occlusionFilterEnabled ? arrayList : theUtil.filter(arrayList, Filters.cache(new OcclusionFilter(iPickSession, taskProgress, ray3d)));
        if (collection.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        this.profileEnd.run();
        return collection;
    }

    private static Ray3d trim(Ray3d ray3d, ConvexHull convexHull) {
        if (convexHull.acceptsAll()) {
            return ray3d;
        }
        if (convexHull.acceptsNone()) {
            return null;
        }
        Vector3d vector3d = ray3d.dir;
        double[] dArray = new double[]{Double.MAX_VALUE, -1.7976931348623157E308};
        DoubleConsumer doubleConsumer = d -> {
            if (d < dArray[0]) {
                dArray[0] = d;
            }
            if (d > dArray[1]) {
                dArray[1] = d;
            }
        };
        BooleanSupplier booleanSupplier = () -> dArray[0] <= 0.0 && dArray[1] >= 1.0;
        if (convexHull.contains(ray3d.p1(), 1.0E-9)) {
            doubleConsumer.accept(0.0);
        }
        if (convexHull.contains(ray3d.p2(), 1.0E-9)) {
            doubleConsumer.accept(ray3d.length);
        }
        Plane3d[] plane3dArray = convexHull.getPlanes();
        for (int i = 0; i < plane3dArray.length && !booleanSupplier.getAsBoolean(); ++i) {
            Plane3d plane3d = plane3dArray[i];
            double d2 = Inter3D.linePlaneIntersectionT(ray3d.origin, vector3d, plane3d, 1.0E-9);
            if (Double.isNaN(d2) || !theUtil.ge0(d2, 1.0E-9) || !theUtil.le(d2, ray3d.length, 1.0E-9) || !convexHull.contains(ray3d.evaluate(d2), 1.0E-9)) continue;
            doubleConsumer.accept(d2);
        }
        if (dArray[0] > dArray[1]) {
            return null;
        }
        return new Ray3d(ray3d.get(dArray[0]), ray3d.dir, dArray[1] - dArray[0]);
    }

    private static ConvexHull intersect(Box3d box3d, ConvexHull convexHull) {
        return box3d.toConvexHull().intersect(convexHull, true);
    }

    public Collection<Object> pickBox(Point2d point2d, Point2d point2d2) {
        return this.pickBox(point2d, point2d2, ACCEPT_ALL);
    }

    public Collection<Object> pickBox(Point2d point2d, Point2d point2d2, IIsectFilter iIsectFilter) {
        Box3d box3d = this.d_view.toFrustum(point2d, point2d2);
        IPickSession iPickSession = this.d_geometry.beginPicking();
        IPickConfig[] iPickConfigArray = iPickSession.getPickConfigs();
        ArrayList<Object> arrayList = iPickConfigArray.length == 1 ? new ArrayList() : new LinkedIdentityHashSet();
        for (IPickConfig iPickConfig : iPickConfigArray) {
            VisibilityFilter visibilityFilter = new VisibilityFilter(iIsectFilter, iPickSession, iPickConfig);
            ConvexHull convexHull = GeomPicker.intersect(box3d, iPickConfig.getClippingRegion());
            BoxSearchResult boxSearchResult = new BoxSearchResult(this.d_view, visibilityFilter, convexHull, iPickSession);
            iPickSession.find(iPickConfig, new CHTest(convexHull), boxSearchResult);
            arrayList.addAll(boxSearchResult.d_objs);
        }
        return arrayList;
    }

    private Ray3d getPickRay(Point2d point2d) {
        Point3d point3d = this.d_view.screenToWorld(new Point3d(point2d.x, point2d.y, 0.0));
        Point3d point3d2 = this.d_view.screenToWorld(new Point3d(point2d.x, point2d.y, 1.0));
        return new Ray3d(point3d, point3d2);
    }

    public double findOccluderDistSq(Point3d point3d) {
        IsectInfo isectInfo = this.findOccluder(new TaskProgress(), point3d);
        if (isectInfo == null) {
            return Double.NaN;
        }
        return isectInfo.isectPoint.distanceSquared(point3d);
    }

    public IsectInfo findOccluder(TaskProgress taskProgress, Point3d point3d) {
        return this.findOccluder(taskProgress, point3d, false);
    }

    public IsectInfo findOccluder(TaskProgress taskProgress, Point3d point3d, boolean bl) {
        Matrix4d matrix4d = this.d_view.getMatrix(6);
        Matrix4d matrix4d2 = this.d_view.getMatrix(7);
        Point3d point3d2 = Util3D.xform(matrix4d, point3d, true);
        point3d2.z = 0.0;
        Point3d point3d3 = Util3D.xform(matrix4d2, point3d2, true);
        Ray3d ray3d = new Ray3d(point3d3, point3d);
        return this.findOccluder(taskProgress, ray3d, bl);
    }

    protected IsectInfo findOccluder(TaskProgress taskProgress, Ray3d ray3d, boolean bl) {
        IPickSession iPickSession = this.d_geometry.beginPicking();
        Point3d point3d = ray3d.p2();
        OccludedPointIsectFilter occludedPointIsectFilter = new OccludedPointIsectFilter(iPickSession, point3d, bl);
        try {
            IPickConfig[] iPickConfigArray;
            for (IPickConfig iPickConfig : iPickConfigArray = iPickSession.getPickConfigs()) {
                Ray3d ray3d2 = GeomPicker.trim(ray3d, iPickConfig.getClippingRegion());
                if (ray3d2 == null) continue;
                LineSegRTreeTest lineSegRTreeTest = new LineSegRTreeTest(ray3d2.p1(), ray3d2.p2());
                RayProxDetector rayProxDetector = new RayProxDetector(ray3d.origin, ray3d2);
                VisibilityFilter visibilityFilter = new VisibilityFilter(occludedPointIsectFilter, iPickSession, iPickConfig);
                RaySearchResult raySearchResult = new RaySearchResult(taskProgress, this.d_view, iPickSession, Mode.SNAP, visibilityFilter, ray3d2, rayProxDetector, iPickConfig);
                iPickSession.find(iPickConfig, lineSegRTreeTest, raySearchResult);
            }
        }
        catch (HaltException haltException) {
            // empty catch block
        }
        return occludedPointIsectFilter.occluder;
    }

    @Deprecated
    protected final double findOccluderDistSq(TaskProgress taskProgress, Ray3d ray3d, IFace iFace, Ray3d ray3d2) {
        return Double.NaN;
    }

    protected double findOccluderDistSq(final TaskProgress taskProgress, Ray3d ray3d, IFace iFace, final IPrimProps iPrimProps, Ray3d ray3d2, final Function<Point3d, Vector3d> function) {
        final Point3d point3d = ray3d2.p2();
        LineSegRTreeTest lineSegRTreeTest = new LineSegRTreeTest(ray3d2.origin, point3d);
        final Point3d[] point3dArray = new Point3d[]{null};
        thunderheadeng.geometry.objs.IIsectCollector iIsectCollector = new thunderheadeng.geometry.objs.IIsectCollector(){

            @Override
            public TaskProgress getProgress() {
                return taskProgress;
            }

            @Override
            public void addNonFace(Object object, Point3d point3d2, GeomType geomType) {
                assert (false);
            }

            @Override
            public void addInfinite(Object object, Point3d point3d2, GeomType geomType, IPrimitive iPrimitive) {
                assert (false);
            }

            @Override
            public void addFace(Object object, Point3d point3d2, int n, Supplier<IFace> supplier, Supplier<Vector3d> supplier2) {
                Vector3d vector3d;
                Vector3d vector3d2;
                if (point3d2.distance(point3d) <= 1.0E-6) {
                    return;
                }
                if (iPrimProps.testOptions(2) && (vector3d2 = supplier2.get()).dot(vector3d = (Vector3d)function.apply(point3d2)) >= 0.0) {
                    return;
                }
                point3dArray[0] = point3d;
                throw new HaltException();
            }
        };
        try {
            iFace.pickPoints(iIsectCollector, new DefaultFilter(GeomType.FACE), null, ray3d2.origin, point3d, ray3d2.dir, lineSegRTreeTest);
        }
        catch (HaltException haltException) {
            // empty catch block
        }
        return point3dArray[0] == null ? Double.NaN : point3dArray[0].distanceSquared(point3d);
    }

    private /* synthetic */ void lambda$new$129() {
        double d = this.d_timer.curr();
        System.out.printf("pick time = %.1f ms%n", d * 1000.0);
    }

    private /* synthetic */ void lambda$new$127() {
        this.d_timer.reset();
    }

    private static class IsectSorter<T>
    implements Comparator<IsectInfo> {
        private static final int[] s_snapTypePriorities = new int[GeomType.values().length];
        private static final int[] s_selTypePriorities;
        private final IPickSession d_geometry;
        private final int[] d_searchPriorities;

        public IsectSorter(Mode mode, IPickSession iPickSession) {
            this.d_searchPriorities = mode == Mode.SNAP ? s_snapTypePriorities : s_selTypePriorities;
            this.d_geometry = iPickSession;
        }

        @Override
        public int compare(IsectInfo isectInfo, IsectInfo isectInfo2) {
            int n;
            int n2 = this.d_searchPriorities[isectInfo.searchType.ordinal()];
            if (n2 == (n = this.d_searchPriorities[isectInfo2.searchType.ordinal()])) {
                int n3 = isectInfo.prox.compareTo(isectInfo2.prox);
                if (n3 == 0) {
                    return isectInfo.obj == isectInfo2.obj ? 0 : this.d_geometry.compare(isectInfo.obj, isectInfo2.obj);
                }
                return n3;
            }
            return n2 - n;
        }

        static {
            IsectSorter.s_snapTypePriorities[GeomType.VERTEX.ordinal()] = 0;
            IsectSorter.s_snapTypePriorities[GeomType.FACE_VERTEX.ordinal()] = 0;
            IsectSorter.s_snapTypePriorities[GeomType.EDGE_VERTEX.ordinal()] = 0;
            IsectSorter.s_snapTypePriorities[GeomType.EDGE.ordinal()] = 1;
            IsectSorter.s_snapTypePriorities[GeomType.FACE_EDGE.ordinal()] = 1;
            IsectSorter.s_snapTypePriorities[GeomType.FACE.ordinal()] = 2;
            s_selTypePriorities = new int[GeomType.values().length];
            IsectSorter.s_selTypePriorities[GeomType.VERTEX.ordinal()] = 0;
            IsectSorter.s_selTypePriorities[GeomType.EDGE.ordinal()] = 1;
            IsectSorter.s_selTypePriorities[GeomType.EDGE_VERTEX.ordinal()] = 2;
            IsectSorter.s_selTypePriorities[GeomType.FACE.ordinal()] = 3;
            IsectSorter.s_selTypePriorities[GeomType.FACE_EDGE.ordinal()] = 4;
            IsectSorter.s_selTypePriorities[GeomType.FACE_VERTEX.ordinal()] = 4;
        }
    }

    private static class RayTolProxDetector
    implements IRayProxDetector {
        private final ConvexHull d_infTolFrustum;
        private final ConvexHull d_tolFrustum;
        private final Point3d d_rayOriginWorld;
        private final Point2d d_rayOriginSc;
        private final double d_tolScrSq;
        private final Matrix4d d_wsXform;

        public RayTolProxDetector(View view, Point3d point3d, Point2d point2d, double d, ConvexHull convexHull) {
            this.d_rayOriginWorld = point3d;
            this.d_infTolFrustum = view.toInfiniteFrustum(point2d, d);
            this.d_tolFrustum = convexHull;
            this.d_rayOriginSc = point2d;
            this.d_tolScrSq = d * d;
            this.d_wsXform = view.getMatrix(6);
        }

        @Override
        public RayPointProx getProximity(Point3d point3d, GeomType geomType, boolean bl) {
            RayPointProx rayPointProx = this.testTolerance(point3d, geomType);
            if (rayPointProx == null) {
                return null;
            }
            if (bl && this.d_infTolFrustum.contains(point3d, 1.0E-6) || !bl && this.d_tolFrustum.contains(point3d, 1.0E-6)) {
                return rayPointProx;
            }
            return null;
        }

        private RayPointProx testTolerance(Point3d point3d, GeomType geomType) {
            double d;
            if (geomType == GeomType.FACE) {
                d = 0.0;
            } else {
                Point3d point3d2 = Util3D.xform(this.d_wsXform, point3d, true);
                double d2 = point3d2.x - this.d_rayOriginSc.x;
                double d3 = point3d2.y - this.d_rayOriginSc.y;
                d = d2 * d2 + d3 * d3;
            }
            if (d > this.d_tolScrSq) {
                return null;
            }
            double d4 = this.d_rayOriginWorld.distance(point3d);
            if (Double.isNaN(d4) || Double.isNaN(d)) {
                assert (false);
                return null;
            }
            return new RayPointProx(d4, Math.sqrt(d));
        }
    }

    private static class RayProxDetector
    implements IRayProxDetector {
        private final Point3d d_rayOriginWorld;
        private final Ray3d d_ray;

        public RayProxDetector(Point3d point3d, Ray3d ray3d) {
            this.d_rayOriginWorld = point3d;
            this.d_ray = ray3d;
        }

        @Override
        public RayPointProx getProximity(Point3d point3d, GeomType geomType, boolean bl) {
            double d = this.d_ray.distance(point3d);
            if (theUtil.lt0(d, 1.0E-9) || theUtil.gt(d, this.d_ray.length, 1.0E-9) || this.d_ray.get(d).distance(point3d) > 1.0E-9) {
                return null;
            }
            if (this.d_rayOriginWorld != this.d_ray.origin) {
                d = Inter3D.nearestTOnLine(this.d_rayOriginWorld, this.d_ray.dir, point3d);
            }
            if (Double.isNaN(d)) {
                assert (false);
                return null;
            }
            return new RayPointProx(d, 0.0);
        }
    }

    public static class IsectCollector
    implements IIsectCollector {
        private final TaskProgress d_progress;
        private final IPickSession d_pickRoot;
        private final View d_view;
        private final IPickConfig d_config;
        private final IIsectFilter d_searchFilter;
        private final List<IsectInfo> d_points;
        private final IRayProxDetector d_proxDet;
        private final Function<Point3d, Vector3d> d_getViewVector;
        private static final IPrimProps.GenericProps DEF_PROPS = new IPrimProps.GenericProps(Color.BLACK, null, 1.0, -1, 1.0, 0);

        public IsectCollector(TaskProgress taskProgress, View view, IPickSession iPickSession, IIsectFilter iIsectFilter, IRayProxDetector iRayProxDetector, IPickConfig iPickConfig) {
            this.d_view = view;
            this.d_pickRoot = iPickSession;
            this.d_searchFilter = iIsectFilter;
            this.d_progress = taskProgress;
            this.d_proxDet = iRayProxDetector;
            this.d_points = new ArrayList<IsectInfo>();
            this.d_config = iPickConfig;
            this.d_getViewVector = this.d_view.getCamera().getViewVectorFunction();
        }

        @Override
        public TaskProgress getProgress() {
            return this.d_progress;
        }

        public List<IsectInfo> getIsects() {
            return this.d_points;
        }

        @Deprecated
        public final void add(Object object, Point3d point3d, GeomType geomType) {
        }

        @Override
        public void addInfinite(Object object, Point3d point3d, GeomType geomType, IPrimitive iPrimitive) {
            this.add(object, point3d, geomType, iPrimitive != null ? () -> iPrimitive : null, DEF_PROPS, true);
        }

        @Override
        public void addNonFace(Object object, Point3d point3d, GeomType geomType) {
            this.add(object, point3d, geomType, null, DEF_PROPS, false);
        }

        @Override
        public void addFace(Object object, Point3d point3d, Supplier<IFace> supplier, Supplier<Vector3d> supplier2, IPrimProps iPrimProps) {
            if (iPrimProps.testOptions(2)) {
                Vector3d vector3d = supplier2.get();
                Vector3d vector3d2 = this.d_getViewVector.apply(point3d);
                if (vector3d2.dot(vector3d) >= 0.0) {
                    return;
                }
            }
            this.add(object, point3d, GeomType.FACE, supplier, iPrimProps, false);
        }

        private void add(Object object, Point3d point3d, GeomType geomType, Supplier<? extends IPrimitive> supplier, IPrimProps iPrimProps, boolean bl) {
            this.d_progress.check();
            RayPointProx rayPointProx = this.d_proxDet.getProximity(point3d, geomType, bl);
            if (rayPointProx != null) {
                IsectInfo isectInfo;
                if ((geomType == GeomType.FACE_EDGE || geomType == GeomType.FACE_VERTEX) && this.d_pickRoot.isWireframe(this.d_config, object)) {
                    geomType = geomType == GeomType.FACE_EDGE ? GeomType.EDGE : GeomType.EDGE_VERTEX;
                }
                if (this.d_searchFilter.acceptIntersection(isectInfo = new IsectInfo(geomType, object, point3d, supplier, iPrimProps, rayPointProx))) {
                    this.d_points.add(isectInfo);
                }
            }
        }
    }

    public static class BoxCollector
    implements IBoxCollector {
        private final BoxSearchResult d_result;
        private final Function<Point3d, Vector3d> d_getViewDir;

        public BoxCollector(View view, BoxSearchResult boxSearchResult) {
            this.d_result = boxSearchResult;
            this.d_getViewDir = view.getCamera().getViewVectorFunction();
        }

        @Override
        public void addNonFace(Object object) throws CancelledException {
            this.addObj(object);
        }

        @Override
        public void addFace(Object object, Supplier<Pair<Point3d, Vector3d>> supplier, IPrimProps iPrimProps) throws CancelledException {
            this.addObj(object);
        }

        private void addObj(Object object) throws CancelledException {
            this.d_result.d_objs.add(object);
            throw new CancelledException();
        }
    }

    private static class RaySearchResult
    implements IResult<IPickable> {
        private final IPickSession d_session;
        private final TaskProgress d_progress;
        private final ITest<AABox> d_tester;
        private final Ray3d d_ray;
        private final IsectCollector d_isectCollector;
        private final Point3d d_p2;

        public RaySearchResult(TaskProgress taskProgress, View view, IPickSession iPickSession, Mode mode, IIsectFilter iIsectFilter, Ray3d ray3d, IRayProxDetector iRayProxDetector, IPickConfig iPickConfig) {
            this(taskProgress, view, iPickSession, mode, iIsectFilter, ray3d, new LineSegRTreeTest(ray3d.p1(), ray3d.p2()), iRayProxDetector, iPickConfig);
        }

        public RaySearchResult(TaskProgress taskProgress, View view, IPickSession iPickSession, Mode mode, IIsectFilter iIsectFilter, Ray3d ray3d, ITest<AABox> iTest, IRayProxDetector iRayProxDetector, IPickConfig iPickConfig) {
            this.d_session = iPickSession;
            this.d_progress = taskProgress;
            this.d_tester = iTest;
            this.d_ray = ray3d;
            this.d_p2 = this.d_ray.p2();
            this.d_isectCollector = new IsectCollector(taskProgress, view, this.d_session, iIsectFilter, iRayProxDetector, iPickConfig);
        }

        public IsectCollector getResult() {
            return this.d_isectCollector;
        }

        public List<IsectInfo> getIsects() {
            return this.d_isectCollector.getIsects();
        }

        @Override
        public void mark(IPickable iPickable, Containment containment) {
            this.d_progress.check();
            this.d_session.pickPoints(iPickable, this.d_isectCollector, this.d_isectCollector.d_searchFilter, this.d_ray.origin, this.d_p2, this.d_ray.dir, this.d_tester);
        }
    }

    private static interface IRayProxDetector {
        public RayPointProx getProximity(Point3d var1, GeomType var2, boolean var3);
    }

    private static class BoxSearchResult
    implements IResult<IPickable> {
        public final List<Object> d_objs;
        private final ConvexHull d_tester;
        private final IIsectFilter d_searchFilter;
        private final IPickSession d_display;
        private final BoxCollector d_result;

        public BoxSearchResult(View view, IIsectFilter iIsectFilter, ConvexHull convexHull, IPickSession iPickSession) {
            this.d_tester = convexHull;
            this.d_objs = new ArrayList<Object>();
            this.d_searchFilter = iIsectFilter;
            this.d_display = iPickSession;
            this.d_result = new BoxCollector(view, this);
        }

        @Override
        public void mark(IPickable iPickable, Containment containment) {
            switch (containment) {
                case INSIDE: {
                    iPickable.getAll(this.d_objs::add, this.d_searchFilter);
                    break;
                }
                default: {
                    this.d_display.pickBox(iPickable, this.d_result, this.d_searchFilter, this.d_tester);
                }
            }
        }
    }

    private static class OccludedPointIsectFilter
    extends DefaultFilter {
        private final IPickSession d_pickRoot;
        private final Point3d d_searchPoint;
        private final boolean d_findClosest;
        public IsectInfo occluder = null;

        public OccludedPointIsectFilter(IPickSession iPickSession, Point3d point3d, boolean bl) {
            super(GeomType.FACE);
            this.d_pickRoot = iPickSession;
            this.d_searchPoint = point3d;
            this.d_findClosest = bl;
        }

        @Override
        public boolean acceptPickObject(Object object) {
            return this.d_pickRoot.isOcclusionSource(object);
        }

        @Override
        public boolean acceptIntersection(IsectInfo isectInfo) {
            double d = isectInfo.isectPoint.distance(this.d_searchPoint);
            if (d > 1.0E-6) {
                if (this.occluder == null || d > this.occluder.isectPoint.distance(this.d_searchPoint)) {
                    this.occluder = isectInfo;
                }
                if (!this.d_findClosest) {
                    throw new HaltException();
                }
            }
            return false;
        }
    }

    private static class HaltException
    extends RuntimeException {
        private HaltException() {
        }
    }

    private class OcclusionFilter
    implements Predicate<IsectInfo> {
        private final TaskProgress d_progress;
        private final IPickSession d_session;
        private final Ray3d d_originalRay;
        private IsectInfo d_firstFaceIsect = null;
        private Map<Point3d, Boolean> d_occludedCache = new HashMap<Point3d, Boolean>();
        private List<IsectInfo> d_foundOccluders = new ArrayList<IsectInfo>();
        private final Matrix4d d_wsXform;
        private final Matrix4d d_swXform;
        private final Function<Point3d, Vector3d> d_getViewVector;

        public OcclusionFilter(IPickSession iPickSession, TaskProgress taskProgress, Ray3d ray3d) {
            this.d_session = iPickSession;
            this.d_progress = taskProgress;
            this.d_wsXform = GeomPicker.this.d_view.getMatrix(6);
            this.d_swXform = GeomPicker.this.d_view.getMatrix(7);
            this.d_originalRay = ray3d;
            this.d_getViewVector = GeomPicker.this.d_view.getCamera().getViewVectorFunction();
        }

        @Override
        public boolean test(IsectInfo isectInfo) {
            if (!this.d_progress.isRunning()) {
                return false;
            }
            if (!this.d_session.isOcclusionTarget(isectInfo.obj)) {
                return true;
            }
            Boolean bl = this.d_occludedCache.get(isectInfo.isectPoint);
            if (bl == null) {
                Object object;
                Ray3d ray3d;
                if (isectInfo.prox.getRDist() == 0.0) {
                    ray3d = new Ray3d(this.d_originalRay.origin, this.d_originalRay.dir, this.d_originalRay.distance(isectInfo.isectPoint));
                } else {
                    object = Util3D.xform(this.d_wsXform, isectInfo.isectPoint, true);
                    ((Point3d)object).z = 0.0;
                    Point3d object2 = Util3D.xform(this.d_swXform, (Point3d)object, true);
                    ray3d = new Ray3d(object2, isectInfo.isectPoint);
                }
                try {
                    for (IsectInfo isectInfo2 : this.d_foundOccluders) {
                        double d = GeomPicker.this.findOccluderDistSq(this.d_progress, this.d_originalRay, (IFace)isectInfo2.getPrim.get(), isectInfo2.props, ray3d, this.d_getViewVector);
                        if (Double.isNaN(d)) continue;
                        bl = true;
                        break;
                    }
                    if (bl == null) {
                        object = GeomPicker.this.findOccluder(this.d_progress, ray3d, false);
                        if (object != null && ((IsectInfo)object).getPrim != null) {
                            this.d_foundOccluders.add((IsectInfo)object);
                        }
                        bl = object != null;
                    }
                    this.d_occludedCache.put(isectInfo.isectPoint, bl);
                }
                catch (HaltException haltException) {
                    bl = true;
                }
            }
            return bl == false;
        }
    }

    private static class VisibilityFilter
    implements IIsectFilter {
        private final IPickSession d_display;
        private final IIsectFilter d_baseFilter;
        private final IPickConfig d_config;

        public VisibilityFilter(IIsectFilter iIsectFilter, IPickSession iPickSession, IPickConfig iPickConfig) {
            this.d_display = iPickSession;
            this.d_baseFilter = iIsectFilter;
            this.d_config = iPickConfig;
        }

        @Override
        public boolean acceptIntersection(IsectInfo isectInfo) {
            return this.d_baseFilter.acceptIntersection(isectInfo);
        }

        @Override
        public boolean acceptGeomType(Object object, GeomType geomType) {
            if (object != null && geomType == GeomType.FACE && this.d_display.isWireframe(this.d_config, object)) {
                return false;
            }
            return this.d_baseFilter.acceptGeomType(object, geomType);
        }

        @Override
        public boolean acceptPickObjType(Class clazz) {
            return this.d_baseFilter.acceptPickObjType(clazz);
        }

        @Override
        public boolean acceptPickObject(Object object) {
            return this.d_baseFilter.acceptPickObject(object) && this.d_display.isVisible(this.d_config, object);
        }
    }

    private static class CHTest
    implements ITest<AABox> {
        public final ConvexHull ch;
        public final double tol;

        public CHTest(ConvexHull convexHull) {
            this(convexHull, 1.0E-9);
        }

        public CHTest(ConvexHull convexHull, double d) {
            this.ch = convexHull;
            this.tol = d;
        }

        @Override
        public Containment test(AABox aABox) {
            return this.ch.test(aABox, this.tol);
        }
    }

    public static enum Mode {
        SNAP,
        PICK;

    }
}

