/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.scene3d.picking;

import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import thunderheadeng.geometry.Inter3D;
import thunderheadeng.geometry.Util3D;
import thunderheadeng.scene3d.picking.ISnapConstraint;
import thunderheadeng.scene3d.picking.LineConstraint;
import thunderheadeng.scene3d.picking.PlanarConstraint;
import thunderheadeng.scene3d.picking.PointConstraint;
import thunderheadeng.util.theUtil;

public class ConstraintUtil {
    public static boolean conflict(ISnapConstraint iSnapConstraint, ISnapConstraint iSnapConstraint2) {
        ISnapConstraint iSnapConstraint3;
        if (iSnapConstraint == null || iSnapConstraint2 == null) {
            return false;
        }
        int n = ConstraintUtil.rank(iSnapConstraint);
        int n2 = ConstraintUtil.rank(iSnapConstraint2);
        if (n2 < n) {
            iSnapConstraint3 = iSnapConstraint;
            iSnapConstraint = iSnapConstraint2;
            iSnapConstraint2 = iSnapConstraint3;
        }
        if (iSnapConstraint instanceof LineConstraint) {
            iSnapConstraint3 = (LineConstraint)iSnapConstraint;
            if (iSnapConstraint2 instanceof LineConstraint) {
                LineConstraint lineConstraint = (LineConstraint)iSnapConstraint2;
                Vector3d vector3d = Util3D.normalize(((LineConstraint)iSnapConstraint3).dir);
                Vector3d vector3d2 = Util3D.normalize(lineConstraint.dir);
                return theUtil.eq0(vector3d.dot(vector3d2), 1.0E-9);
            }
            if (iSnapConstraint2 instanceof PlanarConstraint) {
                PlanarConstraint planarConstraint = (PlanarConstraint)iSnapConstraint2;
                Vector3d vector3d = Util3D.normalize(((LineConstraint)iSnapConstraint3).dir);
                Vector3d vector3d3 = planarConstraint.plane.getNormal();
                double d = Math.abs(vector3d.dot(vector3d3));
                return theUtil.eq(d, 1.0, 1.0E-9);
            }
        }
        return false;
    }

    public static ISnapConstraint intersect(ISnapConstraint iSnapConstraint, ISnapConstraint iSnapConstraint2) throws NoIntersectionException {
        if (iSnapConstraint == null && iSnapConstraint2 == null) {
            return null;
        }
        if (iSnapConstraint == null) {
            return iSnapConstraint2;
        }
        if (iSnapConstraint2 == null) {
            return iSnapConstraint;
        }
        int n = ConstraintUtil.rank(iSnapConstraint);
        int n2 = ConstraintUtil.rank(iSnapConstraint2);
        if (n2 < n) {
            ISnapConstraint iSnapConstraint3 = iSnapConstraint;
            iSnapConstraint = iSnapConstraint2;
            iSnapConstraint2 = iSnapConstraint3;
        }
        if (iSnapConstraint instanceof PointConstraint) {
            if (iSnapConstraint2 instanceof PointConstraint) {
                return ConstraintUtil.intersect((PointConstraint)iSnapConstraint, (PointConstraint)iSnapConstraint2);
            }
            if (iSnapConstraint2 instanceof LineConstraint) {
                return ConstraintUtil.intersect((PointConstraint)iSnapConstraint, (LineConstraint)iSnapConstraint2);
            }
            if (iSnapConstraint2 instanceof PlanarConstraint) {
                return ConstraintUtil.intersect((PointConstraint)iSnapConstraint, (PlanarConstraint)iSnapConstraint2);
            }
        } else if (iSnapConstraint instanceof LineConstraint) {
            if (iSnapConstraint2 instanceof LineConstraint) {
                return ConstraintUtil.intersect((LineConstraint)iSnapConstraint, (LineConstraint)iSnapConstraint2);
            }
            if (iSnapConstraint2 instanceof PlanarConstraint) {
                return ConstraintUtil.intersect((LineConstraint)iSnapConstraint, (PlanarConstraint)iSnapConstraint2);
            }
        } else if (iSnapConstraint instanceof PlanarConstraint && iSnapConstraint2 instanceof PlanarConstraint) {
            return ConstraintUtil.intersect((PlanarConstraint)iSnapConstraint, (PlanarConstraint)iSnapConstraint2);
        }
        throw new NoIntersectionException();
    }

    private static int rank(ISnapConstraint iSnapConstraint) {
        if (iSnapConstraint instanceof PointConstraint) {
            return 0;
        }
        if (iSnapConstraint instanceof LineConstraint) {
            return 1;
        }
        if (iSnapConstraint instanceof PlanarConstraint) {
            return 2;
        }
        return 3;
    }

    public static ISnapConstraint intersect(PointConstraint pointConstraint, PointConstraint pointConstraint2) throws NoIntersectionException {
        if (theUtil.eq0(pointConstraint.p.distance(pointConstraint2.p), 1.0E-9)) {
            return pointConstraint;
        }
        throw new NoIntersectionException();
    }

    public static ISnapConstraint intersect(PointConstraint pointConstraint, LineConstraint lineConstraint) throws NoIntersectionException {
        if (theUtil.eq0(Inter3D.distSqToNearestPtOnLine(lineConstraint.p, lineConstraint.dir, pointConstraint.p), 1.0E-12)) {
            return pointConstraint;
        }
        throw new NoIntersectionException();
    }

    public static ISnapConstraint intersect(PointConstraint pointConstraint, PlanarConstraint planarConstraint) throws NoIntersectionException {
        if (theUtil.eq0(planarConstraint.plane.distance(pointConstraint.p), 1.0E-9)) {
            return pointConstraint;
        }
        throw new NoIntersectionException();
    }

    public static ISnapConstraint intersect(LineConstraint lineConstraint, LineConstraint lineConstraint2) throws NoIntersectionException {
        double d;
        Vector3d vector3d;
        Vector3d vector3d2 = Util3D.normalize(lineConstraint.dir);
        if (theUtil.eq(Math.abs(vector3d2.dot(vector3d = Util3D.normalize(lineConstraint2.dir))), 1.0, 1.0E-9)) {
            if (theUtil.eq0(Inter3D.distSqToNearestPtOnLine(lineConstraint.p, lineConstraint.dir, lineConstraint2.p), 1.0E-12)) {
                return lineConstraint;
            }
            throw new NoIntersectionException();
        }
        Point3d point3d = new Point3d();
        Point3d point3d2 = new Point3d();
        if (Inter3D.lineLineProximity(point3d, point3d2, lineConstraint.p, lineConstraint.dir, lineConstraint2.p, lineConstraint2.dir) && theUtil.eq0(d = point3d.distance(point3d2), 1.0E-9)) {
            return new PointConstraint(point3d);
        }
        throw new NoIntersectionException();
    }

    public static ISnapConstraint intersect(LineConstraint lineConstraint, PlanarConstraint planarConstraint) throws NoIntersectionException {
        Vector3d vector3d = planarConstraint.plane.getNormal();
        if (theUtil.eq0(vector3d.dot(lineConstraint.dir), 1.0E-9)) {
            if (theUtil.eq0(planarConstraint.plane.distance(lineConstraint.p), 1.0E-9)) {
                return lineConstraint;
            }
            throw new NoIntersectionException();
        }
        Point3d point3d = Inter3D.linePlaneIntersection(lineConstraint.p, lineConstraint.dir, planarConstraint.plane, 1.0E-9);
        if (point3d != null) {
            return new PointConstraint(point3d);
        }
        throw new NoIntersectionException();
    }

    public static ISnapConstraint intersect(PlanarConstraint planarConstraint, PlanarConstraint planarConstraint2) throws NoIntersectionException {
        Vector3d vector3d;
        Vector3d vector3d2 = planarConstraint.plane.getNormal();
        if (theUtil.eq(Math.abs(vector3d2.dot(vector3d = planarConstraint2.plane.getNormal())), 1.0, 1.0E-9)) {
            if (theUtil.eq0(planarConstraint.plane.distance(planarConstraint2.plane.getPointOnPlane()), 1.0E-9)) {
                return planarConstraint;
            }
            throw new NoIntersectionException();
        }
        Tuple3d[] tuple3dArray = Inter3D.planePlaneIsect(planarConstraint.plane, planarConstraint2.plane, 1.0E-9);
        if (tuple3dArray != null) {
            return new LineConstraint((Point3d)tuple3dArray[0], (Vector3d)tuple3dArray[1]);
        }
        throw new NoIntersectionException();
    }

    public static class NoIntersectionException
    extends Exception {
    }
}

