/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.scene3d.navtools;

import java.awt.Cursor;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import javax.vecmath.Point2d;
import thunderheadeng.gui.guiUtil;
import thunderheadeng.scene3d.Rectifier;
import thunderheadeng.scene3d.nativebuffered.IRenderSurface;
import thunderheadeng.scene3d.navtools.AToolFunction;
import thunderheadeng.scene3d.navtools.CursorTool;

public class ZoomBoxFunc
extends AToolFunction<CursorTool> {
    public static final Cursor CURSOR = guiUtil.createTeciCursor("Zoom Box", "ZoomboxCur.gif", 15, 15);
    public static final Icon ICON = guiUtil.loadTeciIcon("zoombox16.gif");

    @Override
    public Cursor getCursor(CursorTool cursorTool) {
        return CURSOR;
    }

    @Override
    public boolean showDragGuides(CursorTool cursorTool) {
        return true;
    }

    @Override
    public void mouseDragged(CursorTool cursorTool, MouseEvent mouseEvent) {
    }

    @Override
    public void mouseMoved(CursorTool cursorTool, MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(CursorTool cursorTool, MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(CursorTool cursorTool, MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(CursorTool cursorTool, MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(CursorTool cursorTool, MouseEvent mouseEvent) {
        if (cursorTool.dragAboveTolerance(0)) {
            Point2d point2d = cursorTool.getP0().referenceSnapSc;
            Point2d point2d2 = cursorTool.getP1().referenceSnapSc;
            if (point2d.x == point2d2.x || point2d.y == point2d2.y) {
                cursorTool.repaintSurface();
                return;
            }
            IRenderSurface iRenderSurface = cursorTool.getView().getSurface();
            Rectifier.rectify(point2d, point2d2);
            Point2d point2d3 = new Point2d();
            point2d3.add(point2d2, point2d);
            point2d3.scale(0.5);
            double d = point2d2.x - point2d.x;
            double d2 = point2d2.y - point2d.y;
            double d3 = (double)iRenderSurface.getWidth() / d;
            double d4 = (double)iRenderSurface.getHeight() / d2;
            double d5 = d3 <= d4 ? d3 : d4;
            cursorTool.getView().zoom(d5, point2d3);
            cursorTool.repaintSurface();
        }
    }
}

