/*
 * Decompiled with CFR 0.152.
 */
package thunderheadeng.scene3d.navtools;

import java.awt.Cursor;
import java.awt.event.MouseEvent;
import javax.vecmath.Point2d;
import javax.vecmath.Point3d;
import thunderheadeng.scene3d.navtools.AToolFunction;
import thunderheadeng.scene3d.navtools.CompositeFunc;
import thunderheadeng.scene3d.navtools.CursorTool;
import thunderheadeng.scene3d.navtools.ISelectionLogic;
import thunderheadeng.scene3d.navtools.ISelector;
import thunderheadeng.scene3d.picking.GeomPicker;

public class SelectionFunc
extends AToolFunction<CursorTool>
implements ISelector<CursorTool> {
    private final GeomPicker d_picker;
    private final ISelectionLogic d_selLogic;

    public SelectionFunc(GeomPicker geomPicker, ISelectionLogic iSelectionLogic) {
        this.d_picker = geomPicker;
        this.d_selLogic = iSelectionLogic;
    }

    @Override
    public boolean isAltMenuAccessEnabled() {
        return false;
    }

    @Override
    public String getStatusMessage(CursorTool cursorTool) {
        Point3d point3d = cursorTool.getP1().constrained.isEmpty() ? cursorTool.getP1().referenceSnap : cursorTool.getP1().constrained.getLast();
        return cursorTool.toString(point3d);
    }

    @Override
    public boolean showDragGuides(CursorTool cursorTool) {
        return true;
    }

    @Override
    public boolean isDrawable(CursorTool cursorTool) {
        return !(cursorTool.getFunction() instanceof CompositeFunc);
    }

    @Override
    public void mouseMoved(CursorTool cursorTool, MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(CursorTool cursorTool, MouseEvent mouseEvent) {
    }

    @Override
    public void mouseDragged(CursorTool cursorTool, MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(CursorTool cursorTool, MouseEvent mouseEvent) {
        if (!cursorTool.isDragging()) {
            if (!cursorTool.dragAboveTolerance(1)) {
                this.select(cursorTool, mouseEvent);
            } else {
                this.selectMultiple(cursorTool, mouseEvent);
            }
        }
    }

    private boolean gridSelEnabled(CursorTool cursorTool) {
        return cursorTool.isKeyPressed(71);
    }

    @Override
    public Cursor getCursor(CursorTool cursorTool) {
        return null;
    }

    @Override
    public void select(CursorTool cursorTool, MouseEvent mouseEvent) {
        Point2d point2d = cursorTool.getView().windowScreenToViewScreen(mouseEvent.getPoint());
        this.d_selLogic.selectSingle(cursorTool, mouseEvent, point2d, this.d_picker);
    }

    public void selectMultiple(CursorTool cursorTool, MouseEvent mouseEvent) {
        Point2d point2d = cursorTool.getP0().referenceSnapSc;
        Point2d point2d2 = cursorTool.getP1().referenceSnapSc;
        this.d_selLogic.selectMultiple(cursorTool, mouseEvent, point2d, point2d2, this.d_picker);
    }
}

